/*
 * Decompiled with CFR 0.152.
 */
package de.lxca.slimeRanks.objects.dialogs;

import de.lxca.slimeRanks.Main;
import de.lxca.slimeRanks.guis.RankEditGui;
import de.lxca.slimeRanks.objects.Message;
import de.lxca.slimeRanks.objects.Rank;
import de.lxca.slimeRanks.objects.dialogs.BaseDialog;
import io.papermc.paper.dialog.Dialog;
import io.papermc.paper.registry.data.dialog.ActionButton;
import io.papermc.paper.registry.data.dialog.DialogBase;
import io.papermc.paper.registry.data.dialog.DialogRegistryEntry;
import io.papermc.paper.registry.data.dialog.action.DialogAction;
import io.papermc.paper.registry.data.dialog.body.DialogBody;
import io.papermc.paper.registry.data.dialog.input.DialogInput;
import io.papermc.paper.registry.data.dialog.input.TextDialogInput;
import io.papermc.paper.registry.data.dialog.type.DialogType;
import java.time.temporal.TemporalAmount;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickCallback;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class RankIdentifierDialog
extends BaseDialog {
    private static final String RANK_IDENTIFIER_KEY = "rank_identifier";

    public RankIdentifierDialog(@NotNull Player player) {
        super(player, null, false);
        this.dialog = this.buildDialog();
    }

    @Override
    @NotNull
    protected Dialog buildDialog() {
        return Dialog.create(builder -> ((DialogRegistryEntry.Builder)builder.empty()).base(DialogBase.builder((Component)this.getDialogTitle()).body(List.of(DialogBody.plainMessage((Component)this.getBodyDescription(), (int)300))).inputs(List.of(DialogInput.text((String)RANK_IDENTIFIER_KEY, (int)300, (Component)Component.empty(), (boolean)false, (String)"", (int)32, (TextDialogInput.MultilineOptions)TextDialogInput.MultilineOptions.create((Integer)1, (Integer)17)))).build()).type((DialogType)DialogType.confirmation((ActionButton)ActionButton.create((Component)new Message("dialog.global.back").getMessage(), null, (int)100, null), (ActionButton)ActionButton.create((Component)new Message("dialog.rank_identifier.create").getMessage(), null, (int)100, (DialogAction)this.getCreateRankDialogAction()))));
    }

    private Component getDialogTitle() {
        return new Message("dialog.create_rank.rank_identifier.title").getMessage();
    }

    private Component getBodyDescription() {
        return new Message("dialog.create_rank.rank_identifier.description").getMessage();
    }

    private boolean validateAlphabetic(@NotNull String string) {
        return string.chars().allMatch(Character::isAlphabetic);
    }

    private boolean validateNotExisting(@NotNull String string) {
        YamlConfiguration ranksYml = Main.getRanksYml().getYmlConfig();
        ConfigurationSection ranksSection = ranksYml.getConfigurationSection("Ranks");
        return ranksSection != null && !ranksSection.getKeys(false).contains(string);
    }

    @Contract(value=" -> new")
    @NotNull
    private DialogAction getCreateRankDialogAction() {
        return DialogAction.customClick((view, audience) -> {
            if (!(audience instanceof Player)) {
                return;
            }
            Player player = (Player)audience;
            String input = view.getText(RANK_IDENTIFIER_KEY);
            if (input == null || input.isEmpty() || !this.validateAlphabetic(input)) {
                new Message((CommandSender)player, true, "dialog.create_rank.rank_identifier.error.only_letters");
                player.playSound((Entity)player, Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 1.0f);
                player.closeInventory();
                return;
            }
            if (!this.validateNotExisting(input)) {
                new Message((CommandSender)player, true, "dialog.create_rank.rank_identifier.error.already_used");
                player.playSound((Entity)player, Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 1.0f);
                player.closeInventory();
                return;
            }
            Rank createdRank = Rank.createRank(input);
            if (createdRank == null) {
                new Message((CommandSender)player, true, "dialog.create_rank.rank_identifier.error.creation_failed");
                player.playSound((Entity)player, Sound.BLOCK_ANVIL_DESTROY, 1.0f, 1.0f);
                player.closeInventory();
                return;
            }
            player.playSound((Entity)player, Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
            player.openInventory(new RankEditGui(createdRank).getInventory());
        }, (ClickCallback.Options)((ClickCallback.Options)ClickCallback.Options.builder().uses(1).lifetime((TemporalAmount)ClickCallback.DEFAULT_LIFETIME).build()));
    }
}

