/*
 * Decompiled with CFR 0.152.
 */
package de.lxca.slimeRanks.objects.dialogs;

import de.lxca.slimeRanks.enums.WeightType;
import de.lxca.slimeRanks.guis.RankEditGui;
import de.lxca.slimeRanks.objects.Message;
import de.lxca.slimeRanks.objects.Rank;
import de.lxca.slimeRanks.objects.RankManager;
import de.lxca.slimeRanks.objects.dialogs.BaseDialog;
import io.papermc.paper.dialog.Dialog;
import io.papermc.paper.registry.data.dialog.ActionButton;
import io.papermc.paper.registry.data.dialog.DialogBase;
import io.papermc.paper.registry.data.dialog.DialogRegistryEntry;
import io.papermc.paper.registry.data.dialog.action.DialogAction;
import io.papermc.paper.registry.data.dialog.body.DialogBody;
import io.papermc.paper.registry.data.dialog.input.DialogInput;
import io.papermc.paper.registry.data.dialog.type.DialogType;
import java.time.temporal.TemporalAmount;
import java.util.HashMap;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickCallback;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class WeightDialog
extends BaseDialog {
    private static final String WEIGHT_KEY = "weight";
    private final WeightType weightType;

    public WeightDialog(@NotNull Player player, Rank rank, WeightType weightType) {
        super(player, rank, false);
        this.weightType = weightType;
        this.dialog = this.buildDialog();
    }

    @Override
    @NotNull
    protected Dialog buildDialog() {
        return Dialog.create(builder -> ((DialogRegistryEntry.Builder)builder.empty()).base(DialogBase.builder((Component)this.getDialogTitle()).body(List.of(DialogBody.plainMessage((Component)this.getBodyDescription(), (int)300))).inputs(List.of(DialogInput.numberRange((String)WEIGHT_KEY, (Component)Component.empty(), (float)0.0f, (float)Math.max(this.getCurrentWeight(), 100)).step(Float.valueOf(1.0f)).initial(Float.valueOf(this.getCurrentWeight())).labelFormat("%s %s").width(300).build())).build()).type((DialogType)DialogType.confirmation((ActionButton)ActionButton.create((Component)new Message("dialog.global.back").getMessage(), null, (int)100, null), (ActionButton)ActionButton.create((Component)new Message("dialog.global.save").getMessage(), null, (int)100, (DialogAction)this.getSaveDialogAction()))));
    }

    private int getCurrentWeight() {
        if (this.weightType == WeightType.RANK) {
            return this.rank.getRankPriority();
        }
        return this.rank.getTabPriority();
    }

    private Component getDialogTitle() {
        if (this.weightType == WeightType.RANK) {
            return new Message("dialog.edit_rank.rank_weight.title").getMessage();
        }
        return new Message("dialog.edit_rank.tab_weight.title").getMessage();
    }

    private Component getBodyDescription() {
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("rank", this.rank.getIdentifier());
        if (this.weightType == WeightType.RANK) {
            return new Message("dialog.edit_rank.rank_weight.description", replacements).getMessage();
        }
        return new Message("dialog.edit_rank.tab_weight.description", replacements).getMessage();
    }

    private void setNewWeight(int newWeight) {
        if (this.weightType == WeightType.RANK) {
            this.rank.setRankPriority(newWeight);
        } else {
            this.rank.setTabPriority(newWeight);
        }
        RankManager.getInstance().reloadDisplays();
    }

    @Contract(value=" -> new")
    @NotNull
    private DialogAction getSaveDialogAction() {
        return DialogAction.customClick((view, audience) -> {
            Float weightFloat = view.getFloat(WEIGHT_KEY);
            int newWeight = weightFloat != null ? weightFloat.intValue() : this.getCurrentWeight();
            this.setNewWeight(newWeight);
            if (audience instanceof Player) {
                Player player = (Player)audience;
                player.playSound((Entity)player, Sound.ENTITY_VILLAGER_WORK_CARTOGRAPHER, 1.0f, 1.0f);
                player.openInventory(new RankEditGui(this.rank).getInventory());
            }
        }, (ClickCallback.Options)((ClickCallback.Options)ClickCallback.Options.builder().uses(1).lifetime((TemporalAmount)ClickCallback.DEFAULT_LIFETIME).build()));
    }
}

