/*
 * Decompiled with CFR 0.152.
 */
package icu.suc.realinvisibility;

import icu.suc.realinvisibility.Data;
import icu.suc.realinvisibility.Settings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Pair;

public class Config {
    @NotNull
    public static <T> Pair<Data, Settings<T>> loadConfig(Path dir, final Settings.Slots<T> function) {
        Properties ip = Config.loadConfig(dir, "data.properties");
        Properties sp = Config.loadConfig(dir, "settings.properties");
        return new Pair((Object)new Data(Integer.parseInt(ip.getProperty("DATA_EFFECT_PARTICLES")), Integer.parseInt(ip.getProperty("DATA_ARROW_COUNT_ID")), Integer.parseInt(ip.getProperty("DATA_STINGER_COUNT_ID")), Integer.parseInt(ip.getProperty("DATA_SHARED_FLAGS_ID")), Byte.parseByte(ip.getProperty("BIT_MAP_FIRE"))), (Object)new Settings<T>(Boolean.parseBoolean(sp.getProperty("mainhand", "true")), Boolean.parseBoolean(sp.getProperty("offhand", "true")), Boolean.parseBoolean(sp.getProperty("boots", "true")), Boolean.parseBoolean(sp.getProperty("leggings", "true")), Boolean.parseBoolean(sp.getProperty("chestplate", "true")), Boolean.parseBoolean(sp.getProperty("helmet", "true")), Boolean.parseBoolean(sp.getProperty("body", "true")), Boolean.parseBoolean(sp.getProperty("particles", "true")), Boolean.parseBoolean(sp.getProperty("arrows", "true")), Boolean.parseBoolean(sp.getProperty("stingers", "true")), Boolean.parseBoolean(sp.getProperty("fire", "true"))){

            @Override
            protected Set<T> slots(boolean mainhand, boolean offhand, boolean boots, boolean leggings, boolean chestplate, boolean helmet, boolean body) {
                return function.slots(mainhand, offhand, boots, leggings, chestplate, helmet, body);
            }
        });
    }

    @NotNull
    private static Properties loadConfig(@NotNull Path dir, String file) {
        Path path;
        if (!Files.exists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (!Files.exists(path = dir.resolve(file), new LinkOption[0])) {
            try (InputStream input = Config.class.getClassLoader().getResourceAsStream(file);){
                Files.copy(Objects.requireNonNull(input), path, new CopyOption[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Properties properties = new Properties();
        try (BufferedReader reader = Files.newBufferedReader(path);){
            properties.load(reader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return properties;
    }
}

