/*
 * Decompiled with CFR 0.152.
 */
package icu.suc.realinvisibility;

import com.mojang.datafixers.util.Pair;
import icu.suc.realinvisibility.Data;
import icu.suc.realinvisibility.Settings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.chunk.ChunkSource;
import org.jetbrains.annotations.NotNull;

public class Updater {
    private final Settings<?> settings;
    public final EntityDataAccessor<List<ParticleOptions>> DATA_EFFECT_PARTICLES;
    public final EntityDataAccessor<Integer> DATA_ARROW_COUNT_ID;
    public final EntityDataAccessor<Integer> DATA_STINGER_COUNT_ID;
    public final EntityDataAccessor<Byte> DATA_SHARED_FLAGS_ID;

    public Updater(@NotNull Data data, @NotNull Settings<?> settings) {
        this.settings = settings;
        this.DATA_EFFECT_PARTICLES = new EntityDataAccessor(data.DATA_EFFECT_PARTICLES(), EntityDataSerializers.PARTICLES);
        this.DATA_ARROW_COUNT_ID = new EntityDataAccessor(data.DATA_ARROW_COUNT_ID(), EntityDataSerializers.INT);
        this.DATA_STINGER_COUNT_ID = new EntityDataAccessor(data.DATA_STINGER_COUNT_ID(), EntityDataSerializers.INT);
        this.DATA_SHARED_FLAGS_ID = new EntityDataAccessor(data.DATA_SHARED_FLAGS_ID(), EntityDataSerializers.BYTE);
    }

    public void update(@NotNull LivingEntity entity) {
        this.broadcast(entity, this.packets(entity));
    }

    @NotNull
    protected Collection<Packet<?>> packets(@NotNull LivingEntity entity) {
        ArrayList<Object> list;
        HashSet packets = new HashSet();
        if (this.settings.equipment) {
            ItemStack item;
            list = new ArrayList<Object>();
            if (this.settings.mainhand && !(item = entity.getItemBySlot(EquipmentSlot.MAINHAND)).isEmpty()) {
                list.add(Pair.of((Object)EquipmentSlot.MAINHAND, (Object)item));
            }
            if (this.settings.offhand && !(item = entity.getItemBySlot(EquipmentSlot.OFFHAND)).isEmpty()) {
                list.add(Pair.of((Object)EquipmentSlot.OFFHAND, (Object)item));
            }
            if (this.settings.boots && !(item = entity.getItemBySlot(EquipmentSlot.FEET)).isEmpty()) {
                list.add(Pair.of((Object)EquipmentSlot.FEET, (Object)item));
            }
            if (this.settings.leggings && !(item = entity.getItemBySlot(EquipmentSlot.LEGS)).isEmpty()) {
                list.add(Pair.of((Object)EquipmentSlot.LEGS, (Object)item));
            }
            if (this.settings.chestplate && !(item = entity.getItemBySlot(EquipmentSlot.CHEST)).isEmpty()) {
                list.add(Pair.of((Object)EquipmentSlot.CHEST, (Object)item));
            }
            if (this.settings.helmet && !(item = entity.getItemBySlot(EquipmentSlot.HEAD)).isEmpty()) {
                list.add(Pair.of((Object)EquipmentSlot.HEAD, (Object)item));
            }
            if (this.settings.body && !(item = entity.getItemBySlot(EquipmentSlot.BODY)).isEmpty()) {
                list.add(Pair.of((Object)EquipmentSlot.BODY, (Object)item));
            }
            if (!list.isEmpty()) {
                packets.add((Packet<?>)new ClientboundSetEquipmentPacket(entity.getId(), list));
            }
        }
        if (this.settings.metadata) {
            List<ParticleOptions> particles;
            list = new ArrayList();
            if (this.settings.particles && !(particles = entity.getActiveEffects().stream().filter(effect -> !effect.isVisible()).map(MobEffectInstance::getParticleOptions).toList()).isEmpty()) {
                list.add(SynchedEntityData.DataValue.create(this.DATA_EFFECT_PARTICLES, particles));
            }
            if (this.settings.arrows) {
                list.add(SynchedEntityData.DataValue.create(this.DATA_ARROW_COUNT_ID, (Object)entity.getArrowCount()));
            }
            if (this.settings.stingers) {
                list.add(SynchedEntityData.DataValue.create(this.DATA_STINGER_COUNT_ID, (Object)entity.getStingerCount()));
            }
            if (this.settings.fire) {
                list.add(SynchedEntityData.DataValue.create(this.DATA_SHARED_FLAGS_ID, (Object)((Byte)entity.getEntityData().get(this.DATA_SHARED_FLAGS_ID))));
            }
            if (!list.isEmpty()) {
                packets.add((Packet<?>)new ClientboundSetEntityDataPacket(entity.getId(), list));
            }
        }
        return packets;
    }

    protected void broadcast(@NotNull LivingEntity entity, @NotNull Collection<Packet<?>> packets) {
        ChunkSource chunkSource = entity.level().getChunkSource();
        if (chunkSource instanceof ServerChunkCache) {
            ServerChunkCache cache = (ServerChunkCache)chunkSource;
            for (Packet packet : packets) {
                cache.broadcast((Entity)entity, packet);
            }
        }
    }
}

