/*
 * Decompiled with CFR 0.152.
 */
package icu.suc.realinvisibility.paper;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.protocol.player.EquipmentSlot;
import icu.suc.realinvisibility.Config;
import icu.suc.realinvisibility.Data;
import icu.suc.realinvisibility.Settings;
import icu.suc.realinvisibility.Updater;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Pair;

/*
 * Uses jvm11+ dynamic constants - pseudocode provided - see https://www.benf.org/other/cfr/dynamic-constants.html
 */
public class RealInvisibility
extends JavaPlugin
implements Listener,
PacketListener {
    private Data DATA;
    private Settings<EquipmentSlot> SETTINGS;
    private Updater UPDATER;
    private static final Set<Integer> ID = ConcurrentHashMap.newKeySet();

    public void onEnable() {
        Pair config = Config.loadConfig(this.getDataPath(), (mainhand, offhand, boots, leggings, chestplate, helmet, body) -> {
            HashSet<EquipmentSlot> set = new HashSet<EquipmentSlot>();
            if (mainhand) {
                set.add(EquipmentSlot.MAIN_HAND);
            }
            if (offhand) {
                set.add(EquipmentSlot.OFF_HAND);
            }
            if (boots) {
                set.add(EquipmentSlot.BOOTS);
            }
            if (leggings) {
                set.add(EquipmentSlot.LEGGINGS);
            }
            if (chestplate) {
                set.add(EquipmentSlot.CHEST_PLATE);
            }
            if (helmet) {
                set.add(EquipmentSlot.HELMET);
            }
            if (body) {
                set.add(EquipmentSlot.BODY);
            }
            return set;
        });
        this.DATA = (Data)config.getA();
        this.SETTINGS = (Settings)config.getB();
        if (this.SETTINGS.equipment && this.SETTINGS.metadata) {
            this.UPDATER = new Updater(this.DATA, this.SETTINGS);
            this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
            PacketEvents.getAPI().getEventManager().registerListener((PacketListener)this, PacketListenerPriority.HIGHEST);
        }
    }

    @EventHandler
    private void onPlayerJoin(@NotNull PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (player.hasPotionEffect(PotionEffectType.INVISIBILITY)) {
            ID.add(player.getEntityId());
        }
    }

    @EventHandler
    private void onEntityPotionEffect(@NotNull EntityPotionEffectEvent event) {
        if (!event.getModifiedType().equals(PotionEffectType.INVISIBILITY)) {
            return;
        }
        Entity entity = ((CraftEntity)event.getEntity()).getHandle();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            int id = entity2.getId();
            EntityPotionEffectEvent.Action action = event.getAction();
            if (action.equals((Object)EntityPotionEffectEvent.Action.ADDED)) {
                ID.add(id);
                this.UPDATER.update(entity2);
            } else if (action.equals((Object)EntityPotionEffectEvent.Action.REMOVED) || action.equals((Object)EntityPotionEffectEvent.Action.CLEARED)) {
                ID.remove(id);
                this.UPDATER.update(entity2);
            }
        }
    }

    @EventHandler
    private void onPlayerQuit(@NotNull PlayerQuitEvent event) {
        ID.remove(event.getPlayer().getEntityId());
    }

    /*
     * Exception decompiling
     */
    public void onPacketSend(@NotNull PacketSendEvent event) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't turn ConstantPoolEntry into Literal - got DynamicInfo value=2,438
         *     at org.benf.cfr.reader.bytecode.analysis.parse.literal.TypedLiteral.getConstantPoolEntry(TypedLiteral.java:340)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getBootstrapArg(Op02WithProcessedDataAndRefs.java:538)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getVarArgs(Op02WithProcessedDataAndRefs.java:671)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeBootstrapArgs(Op02WithProcessedDataAndRefs.java:630)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:411)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

