package archives.tater.classicfarlands;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_6910;
import net.minecraft.class_7243;

import static java.lang.Math.max;

public record RadiusCheck(int radius) implements class_6910.class_6913 {
    private static final Codec<Double> CONSTANT_RANGE = Codec.doubleRange(-1000000.0, 1000000.0);
    public static final MapCodec<RadiusCheck> AXIS_VALUE_CODEC = RecordCodecBuilder.mapCodec(
            instance -> instance.group(
                            Codec.INT.fieldOf("radius").forGetter(RadiusCheck::radius)
                    )
                    .apply(instance, RadiusCheck::new)
    );
    public static final class_7243<RadiusCheck> CODEC_HOLDER = class_7243.method_42116(AXIS_VALUE_CODEC);

    @Override
    public double method_40464(class_6910.class_6912 pos) {
        return max(Math.abs(pos.comp_371()), Math.abs(pos.comp_373())) >= radius ? 1.0 : 0.0;
    }

    @Override
    public double comp_377() {
        return 0.0;
    }

    @Override
    public double comp_378() {
        return 1.0;
    }

    @Override
    public class_7243<? extends class_6910> method_41062() {
        return CODEC_HOLDER;
    }
}
