/*
 * Decompiled with CFR 0.152.
 */
package dev.aullisia.pmmsc.screen;

import dev.aullisia.pmmsc.PerMinecartMaxSpeedCustomiserConfig;
import dev.aullisia.pmmsc.network.packet.MinecartMaxSpeedPayload;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_10799;
import net.minecraft.class_1688;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_8710;

public class MinecartSpeedScreen
extends class_437 {
    private static final class_2960 TEXTURE = class_2960.method_60655((String)"pmmsc", (String)"textures/gui/container/minecart_max_speed_menu.png");
    private final class_1688 minecart;
    private class_342 speedInput;
    private double currentSpeed = -1.0;
    private boolean suppressUpdate = false;
    private int x;
    private int y;
    private final int backgroundWidth = 176;
    private final int backgroundHeight = 166;
    private int titleX;
    private int titleY = 6;

    public MinecartSpeedScreen(class_2561 title, class_1688 minecart) {
        super(title);
        this.minecart = minecart;
    }

    protected void method_25426() {
        super.method_25426();
        this.x = (this.field_22789 - 176) / 2;
        this.y = (this.field_22790 - 166) / 2;
        this.titleX = (176 - this.field_22793.method_27525((class_5348)this.field_22785)) / 2;
        this.speedInput = new class_342(this.field_22793, this.x + 90, this.y + 70, 60, 20, class_2561.method_30163((String)"Speed"));
        if (this.currentSpeed <= -1.0) {
            this.speedInput.method_1852("Gamerule");
        } else {
            this.speedInput.method_1852(String.valueOf(this.currentSpeed));
        }
        this.speedInput.method_1863(value -> {
            if (value == null || value.isEmpty()) {
                return;
            }
            try {
                double speed = Double.parseDouble(value);
                if (speed > (double)PerMinecartMaxSpeedCustomiserConfig.minecartMaxSpeed.get().intValue()) {
                    this.speedInput.method_1852(String.valueOf(PerMinecartMaxSpeedCustomiserConfig.minecartMaxSpeed.get()));
                }
                if (this.suppressUpdate) {
                    return;
                }
                if (speed == this.currentSpeed) {
                    return;
                }
                this.sendSpeedPacket(speed);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        this.method_25429((class_364)this.speedInput);
        class_4185 addButton = class_4185.method_46430((class_2561)class_2561.method_30163((String)"+"), btn -> {
            double max = PerMinecartMaxSpeedCustomiserConfig.minecartMaxSpeed.get().intValue();
            double newSpeed = Math.min(this.currentSpeed + 1.0, max);
            this.sendSpeedPacket(newSpeed);
        }).method_46434(this.x + 70, this.y + 70, 20, 20).method_46431();
        this.method_37063((class_364)addButton);
        class_4185 subtractButton = class_4185.method_46430((class_2561)class_2561.method_30163((String)"-"), btn -> {
            double newSpeed = Math.max(this.currentSpeed - 1.0, -1.0);
            this.sendSpeedPacket(newSpeed);
        }).method_46434(this.x + 150, this.y + 70, 20, 20).method_46431();
        this.method_37063((class_364)subtractButton);
    }

    private void sendSpeedPacket(double speed) {
        ClientPlayNetworking.send((class_8710)new MinecartMaxSpeedPayload(speed));
    }

    public void updateSpeedField(double newSpeed) {
        if (newSpeed == this.currentSpeed) {
            return;
        }
        this.currentSpeed = newSpeed;
        if (!this.speedInput.method_25370()) {
            this.suppressUpdate = true;
            if (newSpeed <= -1.0) {
                this.speedInput.method_1852("Gamerule");
            } else {
                this.speedInput.method_1852(String.valueOf(newSpeed));
            }
            this.suppressUpdate = false;
        } else if (newSpeed > (double)PerMinecartMaxSpeedCustomiserConfig.minecartMaxSpeed.get().intValue()) {
            this.speedInput.method_1852(String.valueOf(PerMinecartMaxSpeedCustomiserConfig.minecartMaxSpeed.get()));
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.renderBase(context);
        this.drawBackground(context, delta, mouseX, mouseY);
        this.drawForeground(context, mouseX, mouseY);
        super.method_25394(context, mouseX, mouseY, delta);
        this.speedInput.method_25394(context, mouseX, mouseY, delta);
    }

    private void drawBackground(class_332 context, float delta, int mouseX, int mouseY) {
        int x = (this.field_22789 - 176) / 2;
        int y = (this.field_22790 - 166) / 2 + 40;
        context.method_25290(class_10799.field_56883, TEXTURE, x, y, 0.0f, 0.0f, this.backgroundWidth, this.backgroundHeight, 256, 256);
    }

    private void drawForeground(class_332 context, int mouseX, int mouseY) {
        context.method_51439(this.field_22793, this.field_22785, this.x + this.titleX, this.y + this.titleY + 40, -12566464, false);
        context.method_51439(this.field_22793, class_2561.method_30163((String)"Max Speed"), this.x + 95, this.y + this.titleY + 55, -12566464, false);
    }

    private void renderBase(class_332 context) {
        context.method_25294(0, 0, this.field_22789, this.field_22790, Integer.MIN_VALUE);
    }

    public boolean method_25421() {
        return false;
    }
}

