/*
 * Decompiled with CFR 0.152.
 */
package dev.aullisia.pmmsc.network;

import dev.aullisia.pmmsc.PerMinecartMaxSpeedCustomiserConfig;
import dev.aullisia.pmmsc.component.ModComponents;
import dev.aullisia.pmmsc.network.packet.MinecartMaxSpeedPayload;
import dev.aullisia.pmmsc.network.packet.MinecartMaxSpeedSyncPayload;
import dev.aullisia.pmmsc.screen.MinecartSpeedScreen;
import dev.aullisia.pmmsc.util.CustomMaxSpeedAccessor;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1688;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_437;
import net.minecraft.class_8710;

public class ModNetwork {
    public static void registerServer() {
        PayloadTypeRegistry.playS2C().register(MinecartMaxSpeedSyncPayload.ID, MinecartMaxSpeedSyncPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(MinecartMaxSpeedPayload.ID, MinecartMaxSpeedPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(MinecartMaxSpeedPayload.ID, (payload, context) -> {
            class_3222 player = context.player();
            double speed = payload.speed();
            Objects.requireNonNull(context.server()).execute(() -> {
                class_1799 stack = player.method_5998(player.method_6058());
                UUID cartUuid = (UUID)stack.method_58694(ModComponents.TARGET_MINECART);
                class_1297 cartEntity = player.method_51469().method_66347(cartUuid);
                if (cartEntity instanceof class_1688) {
                    class_1688 cart = (class_1688)cartEntity;
                    double clampedSpeed = Math.min(Math.max(-1.0, speed), (double)PerMinecartMaxSpeedCustomiserConfig.minecartMaxSpeed.get().intValue());
                    ((CustomMaxSpeedAccessor)cart).setCustomMaxSpeed(clampedSpeed);
                    ServerPlayNetworking.send((class_3222)player, (class_8710)new MinecartMaxSpeedSyncPayload(speed));
                }
            });
        });
    }

    @Environment(value=EnvType.CLIENT)
    public static void registerClient() {
        ClientPlayNetworking.registerGlobalReceiver(MinecartMaxSpeedSyncPayload.ID, (payload, context) -> {
            double syncedSpeed = payload.speed();
            context.client().execute(() -> {
                class_437 patt0$temp = class_310.method_1551().field_1755;
                if (patt0$temp instanceof MinecartSpeedScreen) {
                    MinecartSpeedScreen screen = (MinecartSpeedScreen)patt0$temp;
                    screen.updateSpeedField(syncedSpeed);
                }
            });
        });
    }
}

