/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.tfclunchbox.client;

import com.mojang.blaze3d.platform.InputConstants;
import dev.thomas.tfclunchbox.item.CoolingLunchboxItem;
import dev.thomas.tfclunchbox.item.ElectricLunchboxItem;
import dev.thomas.tfclunchbox.item.SimpleLunchboxItem;
import dev.thomas.tfclunchbox.network.NetworkHandler;
import dev.thomas.tfclunchbox.network.SelectSlotPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="tfclunchbox", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class LunchboxClientEvents {
    private static final Logger LOGGER = LogManager.getLogger();

    @SubscribeEvent
    public static void onMouseScroll(InputEvent.MouseScrollingEvent event) {
        try {
            if (!InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)341)) {
                return;
            }
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91074_ == null || minecraft.f_91073_ == null) {
                return;
            }
            ItemStack mainHand = minecraft.f_91074_.m_21205_();
            ItemStack offHand = minecraft.f_91074_.m_21206_();
            ItemStack heldItem = null;
            InteractionHand hand = null;
            int maxSlots = 0;
            if (mainHand.m_41720_() instanceof CoolingLunchboxItem) {
                heldItem = mainHand;
                hand = InteractionHand.MAIN_HAND;
                maxSlots = 9;
            } else if (offHand.m_41720_() instanceof CoolingLunchboxItem) {
                heldItem = offHand;
                hand = InteractionHand.OFF_HAND;
                maxSlots = 9;
            } else if (mainHand.m_41720_() instanceof SimpleLunchboxItem) {
                heldItem = mainHand;
                hand = InteractionHand.MAIN_HAND;
                maxSlots = 9;
            } else if (offHand.m_41720_() instanceof SimpleLunchboxItem) {
                heldItem = offHand;
                hand = InteractionHand.OFF_HAND;
                maxSlots = 9;
            } else if (mainHand.m_41720_() instanceof ElectricLunchboxItem) {
                heldItem = mainHand;
                hand = InteractionHand.MAIN_HAND;
                maxSlots = 9;
            } else if (offHand.m_41720_() instanceof ElectricLunchboxItem) {
                heldItem = offHand;
                hand = InteractionHand.OFF_HAND;
                maxSlots = 9;
            }
            if (heldItem == null || maxSlots == 0) {
                return;
            }
            CompoundTag tag = heldItem.m_41783_();
            if (tag == null || !tag.m_128441_("Items")) {
                return;
            }
            int selectedSlot = tag.m_128451_("SelectedSlot");
            int newSlot = selectedSlot + (int)Math.signum(event.getScrollDelta());
            if (newSlot >= maxSlots) {
                newSlot = 0;
            }
            if (newSlot < 0) {
                newSlot = maxSlots - 1;
            }
            if (newSlot != selectedSlot) {
                NetworkHandler.INSTANCE.sendToServer((Object)new SelectSlotPacket(newSlot));
                event.setCanceled(true);
            }
        }
        catch (Exception e) {
            System.err.println("Error handling mouse scroll event in LunchboxClientEvents: " + e.getMessage());
        }
    }
}

