/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.tfclunchbox.client;

import dev.thomas.tfclunchbox.integration.GregTechCellHelper;
import dev.thomas.tfclunchbox.integration.GregTechIntegration;
import dev.thomas.tfclunchbox.item.CoolingLunchboxItem;
import dev.thomas.tfclunchbox.item.ElectricLunchboxItem;
import dev.thomas.tfclunchbox.item.SimpleLunchboxItem;
import dev.thomas.tfclunchbox.item.UniversalCapsuleItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.items.ItemStackHandler;

public class LunchboxOverlay
implements IGuiOverlay {
    private static final ResourceLocation SLOT_TEXTURE = new ResourceLocation("tfclunchbox", "textures/gui/slot_highlight.png");
    private static final int CENTER_SLOT_SIZE = 20;
    private static final int SIDE_SLOT_SIZE = 14;
    private static final int ICE_SLOT_SIZE = 13;
    private static final int SLOT_SPACING = 2;
    private static final int ANIMATION_DURATION = 10;
    private static final int SLOT_OFFSET_Y = 80;
    private static final int ICE_SLOT_OFFSET_Y = 5;
    private float animationProgress = 0.0f;
    private int targetSlot = 0;
    private int direction = 0;

    public void render(ForgeGui gui, GuiGraphics graphics, float partialTick, int screenWidth, int screenHeight) {
        try {
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            if (player == null || minecraft.f_91073_ == null) {
                return;
            }
            ItemStack heldItem = this.findLunchbox((Player)player);
            if (heldItem == null) {
                return;
            }
            int currentSlot = this.getSelectedSlot(heldItem);
            ItemStackHandler handler = this.getInventory(heldItem);
            if (handler == null) {
                return;
            }
            this.updateAnimation(currentSlot);
            float interpolatedProgress = this.animationProgress + partialTick * (float)this.direction;
            int baseX = screenWidth / 2 - 10;
            int baseY = screenHeight - 80;
            int totalSlots = this.getFoodSlots(heldItem);
            if (totalSlots <= 0) {
                return;
            }
            this.renderSideSlot(graphics, handler, this.getAdjustedSlot(currentSlot, -1, totalSlots), baseX - 14 - 2, baseY + 2, minecraft);
            this.renderSideSlot(graphics, handler, this.getAdjustedSlot(currentSlot, 1, totalSlots), baseX + 20 + 2, baseY + 2, minecraft);
            float offsetX = (float)(this.direction * 22) * (1.0f - interpolatedProgress / 10.0f);
            int animatedX = (int)((float)baseX + offsetX);
            this.renderMainSlot(graphics, handler, currentSlot, animatedX, baseY, minecraft);
            if (heldItem.m_41720_() instanceof CoolingLunchboxItem) {
                this.renderIceSlot(graphics, handler, baseX + 3, baseY + 20 + 5, minecraft);
            }
            if (heldItem.m_41720_() instanceof ElectricLunchboxItem) {
                this.renderEnergySlot(graphics, handler, heldItem, baseX + 3, baseY + 20 + 5, minecraft);
            }
            this.renderSlotNumber(graphics, currentSlot, baseX + 10, baseY - 12, minecraft, totalSlots);
        }
        catch (Exception e) {
            System.err.println("Error rendering lunchbox overlay: " + e.getMessage());
        }
    }

    private void updateAnimation(int newSlot) {
        if (this.targetSlot != newSlot) {
            int lastSlot = this.targetSlot;
            this.targetSlot = newSlot;
            this.direction = Integer.compare(this.targetSlot, lastSlot);
            this.animationProgress = 0.0f;
        }
        if (this.animationProgress < 10.0f) {
            this.animationProgress += 1.0f;
        } else {
            this.direction = 0;
        }
    }

    private void renderMainSlot(GuiGraphics graphics, ItemStackHandler handler, int slot, int x, int y, Minecraft minecraft) {
        graphics.m_280163_(SLOT_TEXTURE, x, y, 0.0f, 0.0f, 20, 20, 20, 20);
        ItemStack stack = handler.getStackInSlot(slot);
        if (!stack.m_41619_()) {
            graphics.m_280480_(stack, x + 2, y + 2);
            graphics.m_280370_(minecraft.f_91062_, stack, x + 2, y + 2);
        }
    }

    private void renderSideSlot(GuiGraphics graphics, ItemStackHandler handler, int slot, int x, int y, Minecraft minecraft) {
        graphics.m_280163_(SLOT_TEXTURE, x, y, 0.0f, 0.0f, 14, 14, 14, 14);
        ItemStack stack = handler.getStackInSlot(slot);
        if (!stack.m_41619_()) {
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_((float)(x + 1), (float)(y + 1), 0.0f);
            graphics.m_280168_().m_85841_(0.7f, 0.7f, 1.0f);
            graphics.m_280480_(stack, 0, 0);
            graphics.m_280370_(minecraft.f_91062_, stack, 0, 0);
            graphics.m_280168_().m_85849_();
        }
    }

    private void renderIceSlot(GuiGraphics graphics, ItemStackHandler handler, int x, int y, Minecraft minecraft) {
        int iceSlotIndex = 10;
        ItemStack iceStack = handler.getStackInSlot(iceSlotIndex);
        boolean isActive = false;
        if (!iceStack.m_41619_()) {
            isActive = iceStack.m_41720_() instanceof UniversalCapsuleItem ? UniversalCapsuleItem.getDurability(iceStack) > 0 : (GregTechCellHelper.isUniversalCell(iceStack) ? GregTechCellHelper.getCellDurability(iceStack) > 0 : true);
        }
        if (!iceStack.m_41619_() && isActive) {
            int durability;
            graphics.m_280163_(SLOT_TEXTURE, x, y, 0.0f, 0.0f, 13, 13, 13, 13);
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85837_((double)x + 1.5, (double)y + 1.5, -1.0);
            graphics.m_280168_().m_85841_(0.6f, 0.6f, 1.0f);
            graphics.m_280480_(iceStack, 0, 0);
            graphics.m_280168_().m_85849_();
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(0.0f, 0.0f, 1.0f);
            if (iceStack.m_41720_() == Items.f_41980_) {
                CompoundTag tag = iceStack.m_41783_();
                int durability2 = 100;
                if (tag != null && tag.m_128441_("IceDurability")) {
                    durability2 = tag.m_128451_("IceDurability");
                }
                this.renderDurabilityBar(graphics, durability2, 100, x, y);
            } else if (iceStack.m_41720_() instanceof UniversalCapsuleItem) {
                int durability3 = UniversalCapsuleItem.getDurability(iceStack);
                if (durability3 > 0) {
                    this.renderDurabilityBar(graphics, durability3, 1000, x, y);
                }
            } else if (GregTechIntegration.isGregTechLoaded() && GregTechCellHelper.isUniversalCell(iceStack) && (durability = GregTechCellHelper.getCellDurability(iceStack)) > 0) {
                this.renderGregTechCellDurabilityBar(graphics, iceStack, x, y);
            }
            graphics.m_280168_().m_85849_();
        }
    }

    private void renderEnergySlot(GuiGraphics graphics, ItemStackHandler handler, ItemStack lunchbox, int x, int y, Minecraft minecraft) {
        int batterySlotIndex = 9;
        ItemStack batteryStack = handler.getStackInSlot(batterySlotIndex);
        long currentEnergy = ElectricLunchboxItem.getStoredEnergy(lunchbox);
        long maxEnergy = 8000L;
        if (currentEnergy > 0L || !batteryStack.m_41619_()) {
            graphics.m_280163_(SLOT_TEXTURE, x, y, 0.0f, 0.0f, 13, 13, 13, 13);
            if (!batteryStack.m_41619_() && ElectricLunchboxItem.isBattery(batteryStack)) {
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_85837_((double)x + 1.5, (double)y + 1.5, -1.0);
                graphics.m_280168_().m_85841_(0.6f, 0.6f, 1.0f);
                graphics.m_280480_(batteryStack, 0, 0);
                graphics.m_280168_().m_85849_();
            }
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(0.0f, 0.0f, 1.0f);
            this.renderEnergyBar(graphics, (int)currentEnergy, (int)maxEnergy, x, y);
            graphics.m_280168_().m_85849_();
        }
    }

    private void renderEnergyBar(GuiGraphics graphics, int current, int max, int x, int y) {
        if (max <= 0) {
            return;
        }
        int barWidth = 11;
        int barHeight = 1;
        int barX = x + 1;
        int barY = y + 13 - barHeight - 1;
        graphics.m_280509_(barX, barY + 1, barX + barWidth + 1, barY + barHeight + 1, -2013265920);
        graphics.m_280509_(barX, barY, barX + barWidth, barY + barHeight, -13421773);
        if (current > 0) {
            int filledWidth = Math.max(1, (int)((float)current / (float)max * (float)barWidth));
            int color = (float)current > (float)max * 0.5f ? -16711936 : ((float)current > (float)max * 0.25f ? -256 : -65536);
            graphics.m_280509_(barX, barY, barX + filledWidth, barY + barHeight, color);
        }
    }

    private void renderDurabilityBar(GuiGraphics graphics, int current, int max, int x, int y) {
        if (current <= 0 || max <= 0) {
            return;
        }
        int barWidth = 11;
        int barHeight = 1;
        int barX = x + 1;
        int barY = y + 13 - barHeight - 1;
        graphics.m_280509_(barX, barY + 1, barX + barWidth + 1, barY + barHeight + 1, -2013265920);
        graphics.m_280509_(barX, barY, barX + barWidth, barY + barHeight, -13421773);
        int filledWidth = Math.max(1, (int)((float)current / (float)max * (float)barWidth));
        int color = (float)current > (float)max * 0.5f ? -16733441 : ((float)current > (float)max * 0.25f ? -22016 : -65536);
        graphics.m_280509_(barX, barY, barX + filledWidth, barY + barHeight, color);
    }

    private void renderGregTechCellDurabilityBar(GuiGraphics graphics, ItemStack stack, int x, int y) {
        if (!GregTechIntegration.isGregTechLoaded() || !GregTechCellHelper.isBarVisible(stack)) {
            return;
        }
        int barWidth = 11;
        int barHeight = 1;
        int barX = x + 1;
        int barY = y + 13 - barHeight - 1;
        graphics.m_280509_(barX, barY + 1, barX + barWidth + 1, barY + barHeight + 1, -2013265920);
        graphics.m_280509_(barX, barY, barX + barWidth, barY + barHeight, -13421773);
        int filledWidth = Math.max(1, (int)((float)GregTechCellHelper.getBarWidth(stack) / 13.0f * (float)barWidth));
        int color = GregTechCellHelper.getBarColor(stack);
        graphics.m_280509_(barX, barY, barX + filledWidth, barY + barHeight, 0xFF000000 | color);
    }

    private int getAdjustedSlot(int current, int offset, int totalSlots) {
        return (current + offset + totalSlots) % totalSlots;
    }

    private void renderSlotNumber(GuiGraphics graphics, int slot, int x, int y, Minecraft minecraft, int totalSlots) {
        String text = slot + 1 + "/" + totalSlots;
        int textWidth = minecraft.f_91062_.m_92895_(text);
        graphics.m_280056_(minecraft.f_91062_, text, x - textWidth / 2, y, 0xFFFFFF, true);
    }

    private ItemStack findLunchbox(Player player) {
        if (player.m_21205_().m_41720_() instanceof CoolingLunchboxItem || player.m_21205_().m_41720_() instanceof SimpleLunchboxItem || player.m_21205_().m_41720_() instanceof ElectricLunchboxItem) {
            return player.m_21205_();
        }
        if (player.m_21206_().m_41720_() instanceof CoolingLunchboxItem || player.m_21206_().m_41720_() instanceof SimpleLunchboxItem || player.m_21206_().m_41720_() instanceof ElectricLunchboxItem) {
            return player.m_21206_();
        }
        return null;
    }

    private int getSelectedSlot(ItemStack lunchbox) {
        CompoundTag tag = lunchbox.m_41783_();
        int maxSlots = this.getFoodSlots(lunchbox);
        return tag != null && tag.m_128441_("SelectedSlot") ? Mth.m_14045_((int)tag.m_128451_("SelectedSlot"), (int)0, (int)(maxSlots - 1)) : 0;
    }

    private ItemStackHandler getInventory(ItemStack lunchbox) {
        CompoundTag tag = lunchbox.m_41783_();
        if (tag == null || !tag.m_128441_("Items")) {
            return null;
        }
        int totalSlots = this.getFoodSlots(lunchbox);
        if (lunchbox.m_41720_() instanceof CoolingLunchboxItem) {
            totalSlots += 3;
        } else if (lunchbox.m_41720_() instanceof ElectricLunchboxItem) {
            ++totalSlots;
        }
        ItemStackHandler handler = new ItemStackHandler(totalSlots);
        handler.deserializeNBT(tag.m_128469_("Items"));
        return handler;
    }

    private int getFoodSlots(ItemStack lunchbox) {
        if (lunchbox.m_41720_() instanceof CoolingLunchboxItem) {
            return 9;
        }
        if (lunchbox.m_41720_() instanceof SimpleLunchboxItem) {
            return 9;
        }
        if (lunchbox.m_41720_() instanceof ElectricLunchboxItem) {
            return 9;
        }
        return 0;
    }
}

