/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.tfclunchbox.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.thomas.tfclunchbox.container.CoolingLunchboxContainer;
import dev.thomas.tfclunchbox.integration.GregTechCellHelper;
import dev.thomas.tfclunchbox.integration.GregTechIntegration;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class CoolingLunchboxScreen
extends AbstractContainerScreen<CoolingLunchboxContainer> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("tfclunchbox", "textures/gui/cooling_lunchbox.png");

    public CoolingLunchboxScreen(CoolingLunchboxContainer container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title);
        this.f_97726_ = 176;
        this.f_97727_ = 166;
    }

    protected void m_7856_() {
        super.m_7856_();
    }

    protected void m_7286_(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        CompoundTag tag;
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        graphics.m_280218_(TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_);
        ItemStack middleSlot = ((CoolingLunchboxContainer)this.f_97732_).m_38853_(10).m_7993_();
        if (!middleSlot.m_41619_() && !middleSlot.m_41720_().m_5524_().contains("capsule") && (tag = middleSlot.m_41783_()) != null && tag.m_128441_("IceDurability")) {
            int durability = tag.m_128451_("IceDurability");
            float durabilityPercent = (float)durability / 100.0f;
            this.renderDurabilityBar(graphics, x + 134, y + 35, durabilityPercent);
        }
    }

    private void renderDurabilityBar(GuiGraphics graphics, int x, int y, float percent) {
        int color;
        int barWidth = 16;
        int barHeight = 2;
        int filledWidth = Math.max(1, (int)((float)barWidth * percent));
        graphics.m_280509_(x, y, x + barWidth, y + barHeight, -13421773);
        int n = percent > 0.5f ? -16733441 : (color = percent > 0.25f ? -22016 : -65536);
        if (filledWidth > 0) {
            graphics.m_280509_(x, y, x + filledWidth, y + barHeight, color);
        }
    }

    private int getSlotXPosition(int slotIndex) {
        int relativeIndex = slotIndex - 9;
        switch (relativeIndex) {
            case 0: {
                return 116;
            }
            case 1: {
                return 134;
            }
            case 2: {
                return 152;
            }
        }
        return 134;
    }

    private int getSlotYPosition(int slotIndex) {
        return 35;
    }

    private void renderGregTechCellDurabilityBar(GuiGraphics graphics, ItemStack stack, int x, int y) {
        if (!GregTechCellHelper.isBarVisible(stack)) {
            return;
        }
        int barWidth = 16;
        int barHeight = 2;
        int barX = x;
        int barY = y + 14;
        graphics.m_280509_(barX, barY + 1, barX + barWidth, barY + barHeight + 1, -2013265920);
        graphics.m_280509_(barX, barY, barX + barWidth, barY + barHeight, -13421773);
        int filledWidth = Math.max(1, (int)((float)GregTechCellHelper.getBarWidth(stack) / 13.0f * (float)barWidth));
        int color = GregTechCellHelper.getBarColor(stack);
        graphics.m_280509_(barX, barY, barX + filledWidth, barY + barHeight, 0xFF000000 | color);
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int slotY;
        int slotX;
        int durability;
        int middleSlotIndex;
        ItemStack middleSlotStack;
        CompoundTag tag;
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        if (GregTechIntegration.isGregTechLoaded()) {
            int durability2;
            int x = (this.f_96543_ - this.f_97726_) / 2;
            int y = (this.f_96544_ - this.f_97727_) / 2;
            int middleSlotIndex2 = 10;
            ItemStack middleSlotStack2 = ((CoolingLunchboxContainer)this.f_97732_).m_38853_(middleSlotIndex2).m_7993_();
            if (!middleSlotStack2.m_41619_() && GregTechCellHelper.isUniversalCell(middleSlotStack2) && (durability2 = GregTechCellHelper.getCellDurability(middleSlotStack2)) > 0) {
                int slotX2 = this.getSlotXPosition(middleSlotIndex2);
                int slotY2 = this.getSlotYPosition(middleSlotIndex2);
                this.renderGregTechCellDurabilityBar(graphics, middleSlotStack2, x + slotX2, y + slotY2);
            }
        }
        boolean isHoveringHelpIcon = this.m_6774_(140, 5, 8, 8, mouseX, mouseY);
        boolean isHoveringIceSlot = this.m_6774_(134, 35, 16, 16, mouseX, mouseY);
        ItemStack middleSlot = ((CoolingLunchboxContainer)this.f_97732_).m_38853_(10).m_7993_();
        boolean shouldRenderCustomTooltip = false;
        ArrayList<MutableComponent> customTooltip = new ArrayList<MutableComponent>();
        if (isHoveringHelpIcon) {
            customTooltip.add(Component.m_237115_((String)"tooltip.tfclunchbox.ice_slots_help"));
            customTooltip.add(Component.m_237115_((String)"tooltip.tfclunchbox.ice_slots_help.line1"));
            customTooltip.add(Component.m_237115_((String)"tooltip.tfclunchbox.ice_slots_help.line2"));
            customTooltip.add(Component.m_237115_((String)"tooltip.tfclunchbox.ice_slots_help.line3"));
            if (GregTechIntegration.isGregTechLoaded()) {
                customTooltip.add(Component.m_237115_((String)"tooltip.tfclunchbox.ice_slots_help.line4"));
            }
            customTooltip.add(Component.m_237115_((String)"tooltip.tfclunchbox.ice_slots_help.line5"));
            shouldRenderCustomTooltip = true;
        } else if (!middleSlot.m_41619_() && isHoveringIceSlot && (tag = middleSlot.m_41783_()) != null && tag.m_128441_("IceDurability")) {
            int durability3 = tag.m_128451_("IceDurability");
            customTooltip.add(Component.m_237110_((String)"tooltip.tfclunchbox.ice_remaining", (Object[])new Object[]{durability3, 100}));
            shouldRenderCustomTooltip = true;
        }
        if (!shouldRenderCustomTooltip && GregTechIntegration.isGregTechLoaded() && !(middleSlotStack = ((CoolingLunchboxContainer)this.f_97732_).m_38853_(middleSlotIndex = 10).m_7993_()).m_41619_() && GregTechCellHelper.isUniversalCell(middleSlotStack) && (durability = GregTechCellHelper.getCellDurability(middleSlotStack)) > 0 && this.m_6774_(slotX = this.getSlotXPosition(middleSlotIndex), slotY = this.getSlotYPosition(middleSlotIndex), 16, 16, mouseX, mouseY)) {
            customTooltip.add(Component.m_237110_((String)"tooltip.tfclunchbox.cell_remaining", (Object[])new Object[]{durability}));
            shouldRenderCustomTooltip = true;
        }
        if (!shouldRenderCustomTooltip) {
            this.m_280072_(graphics, mouseX, mouseY);
        } else {
            graphics.m_280666_(this.f_96547_, customTooltip, mouseX, mouseY);
        }
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280430_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, 0x404040);
    }
}

