/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.tfclunchbox.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.thomas.tfclunchbox.container.ElectricLunchboxContainer;
import dev.thomas.tfclunchbox.item.ElectricLunchboxItem;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public class ElectricLunchboxScreen
extends AbstractContainerScreen<ElectricLunchboxContainer> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("tfclunchbox", "textures/gui/electric_lunchbox.png");

    public ElectricLunchboxScreen(ElectricLunchboxContainer container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title);
        this.f_97726_ = 176;
        this.f_97727_ = 166;
    }

    protected void m_7856_() {
        super.m_7856_();
    }

    protected void m_7286_(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        graphics.m_280218_(TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_);
        this.renderEnergyBar(graphics, x + 155, y + 17, partialTick);
        graphics.m_280218_(TEXTURE, x + 140, y + 5, 176, 0, 8, 8);
    }

    private void renderEnergyBar(GuiGraphics graphics, int x, int y, float partialTick) {
        long energy = ElectricLunchboxItem.getStoredEnergy(((ElectricLunchboxContainer)this.f_97732_).getLunchbox());
        long maxEnergy = 8000L;
        float energyPercent = maxEnergy > 0L ? (float)energy / (float)maxEnergy : 0.0f;
        int barHeight = 52;
        int barWidth = 6;
        int filledHeight = (int)((float)barHeight * energyPercent);
        graphics.m_280509_(x, y, x + barWidth, y + barHeight, -13421773);
        if (filledHeight > 0) {
            int color = energyPercent > 0.5f ? -16711936 : (energyPercent > 0.25f ? -256 : -65536);
            graphics.m_280509_(x, y + barHeight - filledHeight, x + barWidth, y + barHeight, color);
        }
        graphics.m_280509_(x - 1, y - 1, x + barWidth + 1, y, -16777216);
        graphics.m_280509_(x - 1, y + barHeight, x + barWidth + 1, y + barHeight + 1, -16777216);
        graphics.m_280509_(x - 1, y, x, y + barHeight, -16777216);
        graphics.m_280509_(x + barWidth, y, x + barWidth + 1, y + barHeight, -16777216);
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        boolean isHoveringHelpIcon = this.m_6774_(140, 20, 8, 8, mouseX, mouseY);
        boolean shouldRenderCustomTooltip = false;
        ArrayList<MutableComponent> customTooltip = new ArrayList<MutableComponent>();
        if (isHoveringHelpIcon) {
            customTooltip.add(Component.m_237115_((String)"tooltip.tfclunchbox.battery_slot_help"));
            customTooltip.add(Component.m_237115_((String)"tooltip.tfclunchbox.battery_slot_help.line1"));
            customTooltip.add(Component.m_237115_((String)"tooltip.tfclunchbox.battery_slot_help.line2"));
            customTooltip.add(Component.m_237115_((String)"tooltip.tfclunchbox.battery_slot_help.line3"));
            customTooltip.add(Component.m_237115_((String)"tooltip.tfclunchbox.battery_slot_help.line4"));
            shouldRenderCustomTooltip = true;
        }
        if (!shouldRenderCustomTooltip && this.m_6774_(152, 17, 6, 52, mouseX, mouseY)) {
            long energy = ElectricLunchboxItem.getStoredEnergy(((ElectricLunchboxContainer)this.f_97732_).getLunchbox());
            long maxEnergy = 8000L;
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.add(Component.m_237110_((String)"tooltip.tfclunchbox.energy", (Object[])new Object[]{energy, maxEnergy}));
            tooltip.add(Component.m_237110_((String)"tooltip.tfclunchbox.energy_consumption", (Object[])new Object[]{1L}));
            graphics.m_280666_(this.f_96547_, tooltip, mouseX, mouseY);
            return;
        }
        if (!shouldRenderCustomTooltip) {
            this.m_280072_(graphics, mouseX, mouseY);
        } else {
            graphics.m_280666_(this.f_96547_, customTooltip, mouseX, mouseY);
        }
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280430_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, 0x404040);
    }
}

