/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.tfclunchbox.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="tfclunchbox", bus=Mod.EventBusSubscriber.Bus.MOD)
public class TFCLunchBoxConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final double DEFAULT_COOLED_DECAY_MODIFIER = 0.3;
    public static final double DEFAULT_PRESERVED_DECAY_MODIFIER = 0.45;
    public static final ForgeConfigSpec.DoubleValue COOLED_DECAY_MODIFIER;
    public static final ForgeConfigSpec.DoubleValue PRESERVED_DECAY_MODIFIER;
    public static final ForgeConfigSpec SPEC;
    public static double cooledDecayModifier;
    public static double preservedDecayModifier;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        cooledDecayModifier = (Double)COOLED_DECAY_MODIFIER.get();
        preservedDecayModifier = (Double)PRESERVED_DECAY_MODIFIER.get();
    }

    static {
        BUILDER.comment("Food Traits Configuration").comment("NOTE: Changes to trait values require game restart to take effect").push("food_traits");
        COOLED_DECAY_MODIFIER = BUILDER.comment("Decay modifier for COOLED trait (lower = food lasts longer)").defineInRange("cooled_decay_modifier", 0.3, 0.01, 1.0);
        PRESERVED_DECAY_MODIFIER = BUILDER.comment("Decay modifier for PRESERVED trait (lower = food lasts longer)").defineInRange("preserved_decay_modifier", 0.45, 0.01, 1.0);
        BUILDER.pop();
        SPEC = BUILDER.build();
        cooledDecayModifier = 0.3;
        preservedDecayModifier = 0.45;
    }
}

