/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.tfclunchbox.container;

import java.util.EnumSet;
import java.util.Set;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodTrait;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractLunchboxContainer
extends AbstractContainerMenu {
    private static final Set<ClickType> ILLEGAL_ITEM_CLICKS = EnumSet.of(ClickType.QUICK_MOVE, ClickType.PICKUP, ClickType.THROW, ClickType.SWAP);
    protected final ItemStackHandler itemHandler;
    protected final ItemStack lunchbox;
    protected final InteractionHand hand;
    protected final int foodSlots;
    protected final int hotbarIndex;
    protected int itemIndex;

    public AbstractLunchboxContainer(MenuType<?> menuType, int windowId, Inventory playerInventory, ItemStack lunchbox, InteractionHand hand, int foodSlots) {
        super(menuType, windowId);
        this.lunchbox = lunchbox;
        this.hand = hand;
        this.foodSlots = foodSlots;
        this.hotbarIndex = hand == InteractionHand.MAIN_HAND ? playerInventory.f_35977_ : -1;
        this.itemHandler = this.createItemHandler();
        this.loadItems();
        this.updateFoodTraits();
        this.setupSlots(playerInventory);
        if (hand == InteractionHand.MAIN_HAND) {
            int containerSlots = foodSlots + this.getAdditionalSlots();
            this.itemIndex = containerSlots + this.hotbarIndex + 27;
        } else {
            this.itemIndex = -100;
        }
    }

    public AbstractLunchboxContainer(MenuType<?> menuType, int windowId, Inventory playerInventory, FriendlyByteBuf buf, int foodSlots) {
        super(menuType, windowId);
        this.lunchbox = buf.m_130267_();
        this.hand = (InteractionHand)buf.m_130066_(InteractionHand.class);
        this.foodSlots = foodSlots;
        byte slot = buf.readByte();
        this.hotbarIndex = slot == -1 ? -1 : (int)slot;
        this.itemHandler = this.createItemHandler();
        this.loadItems();
        this.updateFoodTraits();
        this.setupSlots(playerInventory);
        if (this.hand == InteractionHand.MAIN_HAND) {
            int containerSlots = foodSlots + this.getAdditionalSlots();
            this.itemIndex = containerSlots + this.hotbarIndex + 27;
        } else {
            this.itemIndex = -100;
        }
    }

    protected abstract int getAdditionalSlots();

    protected abstract ItemStackHandler createItemHandler();

    protected abstract void setupSlots(Inventory var1);

    protected abstract boolean checkItemValid(ItemStack var1);

    protected abstract FoodTrait getFoodTrait();

    protected abstract Class<?> getLunchboxClass();

    protected abstract void updateFoodTraits();

    protected void removeFoodTraits(ItemStack food) {
        if (!food.m_41619_() && this.checkItemValid(food)) {
            FoodCapability.removeTrait((ItemStack)food, (FoodTrait)this.getFoodTrait());
        }
    }

    protected void applyFoodTraits(ItemStack food) {
        if (!food.m_41619_() && this.checkItemValid(food)) {
            FoodCapability.applyTrait((ItemStack)food, (FoodTrait)this.getFoodTrait());
        }
    }

    public ItemStack getTargetStack() {
        if (this.hand == InteractionHand.MAIN_HAND) {
            if (this.itemIndex >= 0 && this.itemIndex < this.f_38839_.size()) {
                return ((Slot)this.f_38839_.get(this.itemIndex)).m_7993_();
            }
            return ItemStack.f_41583_;
        }
        for (int i = this.foodSlots; i < this.f_38839_.size(); ++i) {
            Slot slot = (Slot)this.f_38839_.get(i);
            Container container = slot.f_40218_;
            if (!(container instanceof Inventory)) continue;
            Inventory inv = (Inventory)container;
            return inv.f_35978_.m_21206_();
        }
        return ItemStack.f_41583_;
    }

    public void m_6877_(@NotNull Player player) {
        super.m_6877_(player);
        if (!player.m_9236_().m_5776_()) {
            for (int i = 0; i < this.foodSlots; ++i) {
                ItemStack food = this.itemHandler.getStackInSlot(i);
                if (food.m_41619_()) continue;
                this.removeFoodTraits(food);
            }
            this.saveItems();
            ItemStack currentLunchbox = this.getCurrentLunchbox();
            if (currentLunchbox != null && !currentLunchbox.m_41619_()) {
                currentLunchbox.m_41784_().m_128379_("IsOpen", false);
            }
        }
    }

    public boolean m_6875_(@NotNull Player player) {
        ItemStack targetStack = this.getTargetStack();
        return !targetStack.m_41619_() && targetStack.m_41720_().getClass().isAssignableFrom(this.getLunchboxClass());
    }

    public void m_150399_(int slot, int dragType, ClickType clickType, Player player) {
        if (slot == this.itemIndex && ILLEGAL_ITEM_CLICKS.contains(clickType) || dragType == this.hotbarIndex && clickType == ClickType.SWAP || dragType == 40 && clickType == ClickType.SWAP && this.hand == InteractionHand.OFF_HAND || clickType == ClickType.PICKUP_ALL) {
            return;
        }
        super.m_150399_(slot, dragType, clickType, player);
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < this.foodSlots) {
                this.removeFoodTraits(itemstack1);
                if (!this.m_38903_(itemstack1, this.foodSlots, this.f_38839_.size(), true)) {
                    return ItemStack.f_41583_;
                }
            } else if (!this.m_38903_(itemstack1, 0, this.foodSlots, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    protected void loadItems() {
        CompoundTag tag = this.lunchbox.m_41784_();
        if (tag.m_128441_("Items")) {
            this.itemHandler.deserializeNBT(tag.m_128469_("Items"));
        }
    }

    protected void saveItems() {
        ItemStack currentLunchbox = this.getCurrentLunchbox();
        if (currentLunchbox != null && !currentLunchbox.m_41619_()) {
            CompoundTag tag = currentLunchbox.m_41784_();
            tag.m_128365_("Items", (Tag)this.itemHandler.serializeNBT());
        }
    }

    public ItemStack getLunchbox() {
        return this.lunchbox;
    }

    public ItemStack getCurrentLunchbox() {
        for (int i = this.foodSlots; i < this.f_38839_.size(); ++i) {
            Slot slot = (Slot)this.f_38839_.get(i);
            Container container = slot.f_40218_;
            if (!(container instanceof Inventory)) continue;
            Inventory inv = (Inventory)container;
            Player player = inv.f_35978_;
            ItemStack heldItem = player.m_21120_(this.hand);
            if (!heldItem.m_41720_().getClass().isAssignableFrom(this.getLunchboxClass())) break;
            return heldItem;
        }
        return this.lunchbox;
    }

    protected void addPlayerInventorySlots(Inventory playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, 8 + col * 18, 142));
        }
    }

    public void m_142503_(ItemStack stack) {
        if (!stack.m_41619_() && this.checkItemValid(stack)) {
            this.removeFoodTraits(stack);
        }
        super.m_142503_(stack);
    }

    protected class FoodSlot
    extends SlotItemHandler {
        public FoodSlot(ItemStackHandler handler, int index, int x, int y) {
            super((IItemHandler)handler, index, x, y);
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            return AbstractLunchboxContainer.this.checkItemValid(stack);
        }

        public void m_142406_(@NotNull Player player, @NotNull ItemStack stack) {
            AbstractLunchboxContainer.this.removeFoodTraits(stack);
            super.m_142406_(player, stack);
        }

        public void m_5852_(@NotNull ItemStack stack) {
            super.m_5852_(stack);
            if (!stack.m_41619_() && AbstractLunchboxContainer.this.checkItemValid(stack)) {
                AbstractLunchboxContainer.this.applyFoodTraits(stack);
            }
        }
    }
}

