/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.tfclunchbox.container;

import dev.thomas.tfclunchbox.container.AbstractLunchboxContainer;
import dev.thomas.tfclunchbox.container.ModContainers;
import dev.thomas.tfclunchbox.integration.GregTechCellHelper;
import dev.thomas.tfclunchbox.item.CoolingLunchboxCapabilityProvider;
import dev.thomas.tfclunchbox.item.CoolingLunchboxItem;
import dev.thomas.tfclunchbox.item.UniversalCapsuleItem;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodTrait;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class CoolingLunchboxContainer
extends AbstractLunchboxContainer {
    public CoolingLunchboxContainer(int windowId, Inventory playerInventory, ItemStack lunchbox, InteractionHand hand) {
        super((MenuType)ModContainers.COOLING_LUNCHBOX_CONTAINER.get(), windowId, playerInventory, lunchbox, hand, 9);
    }

    public CoolingLunchboxContainer(int windowId, Inventory playerInventory, FriendlyByteBuf buf) {
        super((MenuType)ModContainers.COOLING_LUNCHBOX_CONTAINER.get(), windowId, playerInventory, buf, 9);
    }

    @Override
    protected ItemStackHandler createItemHandler() {
        return new ItemStackHandler(12){
            private boolean isUpdating;
            {
                this.isUpdating = false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onContentsChanged(int slot) {
                if (this.isUpdating) {
                    return;
                }
                this.isUpdating = true;
                try {
                    super.onContentsChanged(slot);
                    CoolingLunchboxContainer.this.saveItems();
                    if (CoolingLunchboxContainer.this.lunchbox.m_41720_() instanceof CoolingLunchboxItem) {
                        int durability;
                        ItemStack middleCapsule;
                        ItemStack lowerIce = this.getStackInSlot(10);
                        ItemStack capsule = this.getStackInSlot(11);
                        boolean hasIce = false;
                        if (!lowerIce.m_41619_()) {
                            hasIce = lowerIce.m_41720_() instanceof UniversalCapsuleItem ? UniversalCapsuleItem.getDurability(lowerIce) > 0 : (GregTechCellHelper.isUniversalCell(lowerIce) ? GregTechCellHelper.getCellDurability(lowerIce) > 0 : true);
                        }
                        for (int i = 0; i < 9; ++i) {
                            ItemStack food = this.getStackInSlot(i);
                            if (food.m_41619_() || !CoolingLunchboxItem.checkItemValid(food)) continue;
                            if (hasIce) {
                                FoodCapability.applyTrait((ItemStack)food, (FoodTrait)CoolingLunchboxItem.getLunchboxCooledTrait());
                                continue;
                            }
                            FoodCapability.removeTrait((ItemStack)food, (FoodTrait)CoolingLunchboxItem.getLunchboxCooledTrait());
                        }
                        int upper = 9;
                        int middle = 10;
                        ItemStack upperIce = this.getStackInSlot(upper);
                        if (!upperIce.m_41619_() && lowerIce.m_41619_() && capsule.m_41619_()) {
                            if (upperIce.m_41720_() instanceof UniversalCapsuleItem) {
                                int durability2 = UniversalCapsuleItem.getDurability(upperIce);
                                if (durability2 > 0) {
                                    moved = upperIce.m_41620_(1);
                                    this.setStackInSlot(middle, moved);
                                } else {
                                    moved = upperIce.m_41620_(1);
                                    this.setStackInSlot(11, moved);
                                }
                            } else if (GregTechCellHelper.isUniversalCell(upperIce)) {
                                int durability3 = GregTechCellHelper.getCellDurability(upperIce);
                                if (durability3 > 0) {
                                    moved = upperIce.m_41620_(1);
                                    this.setStackInSlot(middle, moved);
                                } else {
                                    moved = upperIce.m_41620_(1);
                                    this.setStackInSlot(11, moved);
                                }
                            } else {
                                ItemStack moved = upperIce.m_41620_(1);
                                CompoundTag tag = moved.m_41784_();
                                tag.m_128405_("IceDurability", 100);
                                moved.m_41751_(tag);
                                this.setStackInSlot(middle, moved);
                            }
                        }
                        if ((middleCapsule = this.getStackInSlot(middle)).m_41720_() instanceof UniversalCapsuleItem) {
                            int durability4 = UniversalCapsuleItem.getDurability(middleCapsule);
                            if (durability4 <= 0) {
                                this.setStackInSlot(11, middleCapsule);
                                this.setStackInSlot(middle, ItemStack.f_41583_);
                            }
                        } else if (GregTechCellHelper.isUniversalCell(middleCapsule) && (durability = GregTechCellHelper.getCellDurability(middleCapsule)) <= 0) {
                            this.setStackInSlot(11, middleCapsule);
                            this.setStackInSlot(middle, ItemStack.f_41583_);
                        }
                    }
                }
                finally {
                    this.isUpdating = false;
                }
            }
        };
    }

    @Override
    protected void setupSlots(Inventory playerInventory) {
        int containerRows = 3;
        for (int row = 0; row < containerRows; ++row) {
            int containerColumns = 3;
            for (int col = 0; col < containerColumns; ++col) {
                this.m_38897_((Slot)new FoodSlot(this.itemHandler, row * containerColumns + col, 8 + col * 18, 17 + row * 18));
            }
        }
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.itemHandler, 9, 134, 17){

            public boolean m_5857_(@NotNull ItemStack stack) {
                boolean isIce = CoolingLunchboxCapabilityProvider.ICE_VALIDATOR.test(stack);
                boolean isCapsule = stack.m_41720_() instanceof UniversalCapsuleItem;
                boolean isGregTechCell = GregTechCellHelper.isUniversalCell(stack);
                return isIce || isCapsule || isGregTechCell;
            }

            public void m_5852_(@NotNull ItemStack stack) {
                super.m_5852_(stack);
                CoolingLunchboxContainer.this.updateFoodTraits();
            }
        });
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.itemHandler, 10, 134, 35){

            public boolean m_5857_(@NotNull ItemStack stack) {
                return false;
            }

            public boolean m_8010_(@NotNull Player player) {
                return false;
            }

            public void m_5852_(@NotNull ItemStack stack) {
                super.m_5852_(stack);
                CoolingLunchboxContainer.this.updateFoodTraits();
            }
        });
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.itemHandler, 11, 134, 53){

            public boolean m_5857_(@NotNull ItemStack stack) {
                return false;
            }

            public void m_5852_(@NotNull ItemStack stack) {
                super.m_5852_(stack);
                CoolingLunchboxContainer.this.updateFoodTraits();
            }
        });
        this.addPlayerInventorySlots(playerInventory);
    }

    @Override
    protected boolean checkItemValid(ItemStack stack) {
        return CoolingLunchboxItem.checkItemValid(stack);
    }

    @Override
    protected FoodTrait getFoodTrait() {
        return CoolingLunchboxItem.getLunchboxCooledTrait();
    }

    @Override
    protected Class<?> getLunchboxClass() {
        return CoolingLunchboxItem.class;
    }

    @Override
    protected void updateFoodTraits() {
        ItemStack lowerIce = this.itemHandler.getStackInSlot(10);
        ItemStack capsule = this.itemHandler.getStackInSlot(11);
        boolean hasIce = false;
        if (!lowerIce.m_41619_()) {
            hasIce = lowerIce.m_41720_() instanceof UniversalCapsuleItem ? UniversalCapsuleItem.getDurability(lowerIce) > 0 : (GregTechCellHelper.isUniversalCell(lowerIce) ? GregTechCellHelper.getCellDurability(lowerIce) > 0 : true);
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack food = this.itemHandler.getStackInSlot(i);
            if (food.m_41619_() || !CoolingLunchboxItem.checkItemValid(food)) continue;
            if (hasIce) {
                FoodCapability.applyTrait((ItemStack)food, (FoodTrait)CoolingLunchboxItem.getLunchboxCooledTrait());
                continue;
            }
            FoodCapability.removeTrait((ItemStack)food, (FoodTrait)CoolingLunchboxItem.getLunchboxCooledTrait());
        }
    }

    @Override
    public void m_142503_(ItemStack stack) {
        if (!stack.m_41619_() && CoolingLunchboxItem.checkItemValid(stack)) {
            FoodCapability.removeTrait((ItemStack)stack, (FoodTrait)CoolingLunchboxItem.getLunchboxCooledTrait());
        }
        super.m_142503_(stack);
    }

    @Override
    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            boolean fromLunchbox;
            ItemStack stack = slot.m_7993_();
            itemstack = stack.m_41777_();
            boolean bl = fromLunchbox = index < 12;
            if (fromLunchbox) {
                FoodCapability.removeTrait((ItemStack)stack, (FoodTrait)CoolingLunchboxItem.getLunchboxCooledTrait());
                if (!this.m_38903_(stack, 12, this.f_38839_.size(), true)) {
                    return ItemStack.f_41583_;
                }
            } else {
                if (stack.m_41720_() instanceof CoolingLunchboxItem) {
                    return ItemStack.f_41583_;
                }
                boolean moved = false;
                if (CoolingLunchboxCapabilityProvider.ICE_VALIDATOR.test(stack) || stack.m_41720_() instanceof UniversalCapsuleItem || GregTechCellHelper.isUniversalCell(stack)) {
                    moved = this.handleSpecialItems(stack);
                }
                if (!moved) {
                    moved = this.m_38903_(stack, 0, 9, false);
                }
                if (!moved) {
                    return ItemStack.f_41583_;
                }
            }
            if (stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (fromLunchbox) {
                FoodCapability.removeTrait((ItemStack)stack, (FoodTrait)CoolingLunchboxItem.getLunchboxCooledTrait());
            }
        }
        return itemstack;
    }

    @Override
    protected int getAdditionalSlots() {
        return 3;
    }

    private boolean handleSpecialItems(ItemStack stack) {
        Slot targetSlot = this.m_38853_(9);
        if (targetSlot.m_5857_(stack)) {
            int total;
            if (targetSlot.m_7993_().m_41619_()) {
                targetSlot.m_5852_(stack.m_41620_(1));
                return true;
            }
            if (ItemStack.m_150942_((ItemStack)targetSlot.m_7993_(), (ItemStack)stack) && (total = targetSlot.m_7993_().m_41613_() + stack.m_41613_()) <= stack.m_41741_()) {
                targetSlot.m_7993_().m_41769_(stack.m_41613_());
                stack.m_41764_(0);
                return true;
            }
        }
        return false;
    }

    private static class FoodSlot
    extends SlotItemHandler {
        public FoodSlot(ItemStackHandler handler, int index, int x, int y) {
            super((IItemHandler)handler, index, x, y);
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            return CoolingLunchboxItem.checkItemValid(stack) && !CoolingLunchboxCapabilityProvider.ICE_VALIDATOR.test(stack) && !(stack.m_41720_() instanceof UniversalCapsuleItem);
        }

        public void m_142406_(@NotNull Player player, @NotNull ItemStack stack) {
            FoodCapability.removeTrait((ItemStack)stack, (FoodTrait)CoolingLunchboxItem.getLunchboxCooledTrait());
            super.m_142406_(player, stack);
        }

        public void m_5852_(@NotNull ItemStack stack) {
            super.m_5852_(stack);
            if (!stack.m_41619_() && CoolingLunchboxItem.checkItemValid(stack)) {
                ItemStackHandler handler = (ItemStackHandler)this.getItemHandler();
                ItemStack lowerIce = handler.getStackInSlot(10);
                ItemStack capsule = handler.getStackInSlot(11);
                boolean hasIce = false;
                if (!lowerIce.m_41619_()) {
                    hasIce = lowerIce.m_41720_() instanceof UniversalCapsuleItem ? UniversalCapsuleItem.getDurability(lowerIce) > 0 : (GregTechCellHelper.isUniversalCell(lowerIce) ? GregTechCellHelper.getCellDurability(lowerIce) > 0 : true);
                }
                if (hasIce) {
                    FoodCapability.applyTrait((ItemStack)stack, (FoodTrait)CoolingLunchboxItem.getLunchboxCooledTrait());
                }
            }
        }
    }
}

