/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.tfclunchbox.container;

import dev.thomas.tfclunchbox.container.AbstractLunchboxContainer;
import dev.thomas.tfclunchbox.container.ModContainers;
import dev.thomas.tfclunchbox.integration.GregTechIntegration;
import dev.thomas.tfclunchbox.item.ElectricLunchboxItem;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodTrait;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class ElectricLunchboxContainer
extends AbstractLunchboxContainer {
    public ElectricLunchboxContainer(int windowId, Inventory playerInventory, ItemStack lunchbox, InteractionHand hand) {
        super((MenuType)ModContainers.ELECTRIC_LUNCHBOX_CONTAINER.get(), windowId, playerInventory, lunchbox, hand, 9);
    }

    public ElectricLunchboxContainer(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        super((MenuType)ModContainers.ELECTRIC_LUNCHBOX_CONTAINER.get(), windowId, playerInventory, data, 9);
    }

    @Override
    protected ItemStackHandler createItemHandler() {
        return new ItemStackHandler(10){
            private boolean isUpdating;
            {
                this.isUpdating = false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onContentsChanged(int slot) {
                if (this.isUpdating) {
                    return;
                }
                this.isUpdating = true;
                try {
                    super.onContentsChanged(slot);
                    ElectricLunchboxContainer.this.saveItems();
                    if (GregTechIntegration.isGregTechLoaded() && ElectricLunchboxContainer.this.lunchbox.m_41720_() instanceof ElectricLunchboxItem) {
                        long energy;
                        ItemStack battery = this.getStackInSlot(9);
                        if (!battery.m_41619_() && ElectricLunchboxItem.isBattery(battery)) {
                            ElectricLunchboxItem.chargeFromBattery(ElectricLunchboxContainer.this.lunchbox, battery);
                        }
                        boolean hasEnergy = (energy = ElectricLunchboxItem.getStoredEnergy(ElectricLunchboxContainer.this.lunchbox)) >= 1L;
                        for (int i = 0; i < 9; ++i) {
                            ItemStack food = this.getStackInSlot(i);
                            if (food.m_41619_() || !ElectricLunchboxItem.checkItemValid(food)) continue;
                            if (hasEnergy) {
                                FoodCapability.applyTrait((ItemStack)food, (FoodTrait)ElectricLunchboxItem.getLunchboxCooledTrait());
                                continue;
                            }
                            FoodCapability.removeTrait((ItemStack)food, (FoodTrait)ElectricLunchboxItem.getLunchboxCooledTrait());
                        }
                    }
                }
                finally {
                    this.isUpdating = false;
                }
            }
        };
    }

    @Override
    protected void setupSlots(Inventory playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                this.m_38897_((Slot)new CustomSlotItemHandler((IItemHandler)this.itemHandler, row * 3 + col, 8 + col * 18, 17 + row * 18));
            }
        }
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.itemHandler, 9, 134, 35){

            public boolean m_5857_(@NotNull ItemStack stack) {
                return ElectricLunchboxItem.isBattery(stack);
            }

            public void m_5852_(@NotNull ItemStack stack) {
                super.m_5852_(stack);
                ElectricLunchboxContainer.this.updateFoodTraits();
            }
        });
        this.addPlayerInventorySlots(playerInventory);
    }

    @Override
    protected boolean checkItemValid(ItemStack stack) {
        return ElectricLunchboxItem.checkItemValid(stack);
    }

    @Override
    protected FoodTrait getFoodTrait() {
        return ElectricLunchboxItem.getLunchboxCooledTrait();
    }

    @Override
    protected Class<?> getLunchboxClass() {
        return ElectricLunchboxItem.class;
    }

    @Override
    protected void updateFoodTraits() {
        long energy;
        if (!GregTechIntegration.isGregTechLoaded()) {
            return;
        }
        ItemStack battery = this.itemHandler.getStackInSlot(9);
        if (!battery.m_41619_() && ElectricLunchboxItem.isBattery(battery)) {
            ElectricLunchboxItem.chargeFromBattery(this.lunchbox, battery);
        }
        boolean hasEnergy = (energy = ElectricLunchboxItem.getStoredEnergy(this.lunchbox)) >= 1L;
        for (int i = 0; i < 9; ++i) {
            ItemStack food = this.itemHandler.getStackInSlot(i);
            if (food.m_41619_() || !ElectricLunchboxItem.checkItemValid(food)) continue;
            if (hasEnergy) {
                FoodCapability.applyTrait((ItemStack)food, (FoodTrait)ElectricLunchboxItem.getLunchboxCooledTrait());
                continue;
            }
            FoodCapability.removeTrait((ItemStack)food, (FoodTrait)ElectricLunchboxItem.getLunchboxCooledTrait());
        }
    }

    @Override
    public void m_142503_(@NotNull ItemStack stack) {
        super.m_142503_(stack);
        if (!stack.m_41619_() && ElectricLunchboxItem.checkItemValid(stack) && GregTechIntegration.isGregTechLoaded()) {
            FoodCapability.removeTrait((ItemStack)stack, (FoodTrait)ElectricLunchboxItem.getLunchboxCooledTrait());
        }
    }

    @Override
    public void m_6877_(@NotNull Player player) {
        ItemStack held;
        super.m_6877_(player);
        if (!player.m_9236_().m_5776_() && (held = player.m_21120_(this.hand)) != null && held.m_41720_() instanceof ElectricLunchboxItem) {
            held.m_41784_().m_128379_("IsOpen", false);
        }
    }

    @Override
    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            boolean fromLunchbox;
            ItemStack stack = slot.m_7993_();
            itemstack = stack.m_41777_();
            boolean bl = fromLunchbox = index < 10;
            if (fromLunchbox) {
                if (GregTechIntegration.isGregTechLoaded()) {
                    FoodCapability.removeTrait((ItemStack)stack, (FoodTrait)ElectricLunchboxItem.getLunchboxCooledTrait());
                }
                if (!this.m_38903_(stack, 10, this.f_38839_.size(), true)) {
                    return ItemStack.f_41583_;
                }
            } else {
                if (stack.m_41720_() instanceof ElectricLunchboxItem) {
                    return ItemStack.f_41583_;
                }
                boolean moved = false;
                if (ElectricLunchboxItem.isBattery(stack)) {
                    moved = this.m_38903_(stack, 9, 10, false);
                }
                if (!moved) {
                    moved = this.m_38903_(stack, 0, 9, false);
                }
                if (!moved) {
                    return ItemStack.f_41583_;
                }
            }
            if (stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (fromLunchbox && GregTechIntegration.isGregTechLoaded()) {
                FoodCapability.removeTrait((ItemStack)stack, (FoodTrait)ElectricLunchboxItem.getLunchboxCooledTrait());
            }
        }
        return itemstack;
    }

    @Override
    protected int getAdditionalSlots() {
        return 1;
    }

    private class CustomSlotItemHandler
    extends SlotItemHandler {
        public CustomSlotItemHandler(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            return ElectricLunchboxItem.checkItemValid(stack);
        }

        @NotNull
        public ItemStack m_6201_(int amount) {
            ItemStack result = super.m_6201_(amount);
            if (!result.m_41619_() && GregTechIntegration.isGregTechLoaded()) {
                FoodCapability.removeTrait((ItemStack)result, (FoodTrait)ElectricLunchboxItem.getLunchboxCooledTrait());
            }
            return result;
        }

        public void m_5852_(@NotNull ItemStack stack) {
            super.m_5852_(stack);
            if (!stack.m_41619_() && ElectricLunchboxItem.checkItemValid(stack) && GregTechIntegration.isGregTechLoaded()) {
                boolean hasEnergy;
                long energy = ElectricLunchboxItem.getStoredEnergy(ElectricLunchboxContainer.this.lunchbox);
                boolean bl = hasEnergy = energy >= 1L;
                if (hasEnergy) {
                    FoodCapability.applyTrait((ItemStack)stack, (FoodTrait)ElectricLunchboxItem.getLunchboxCooledTrait());
                }
            }
        }
    }
}

