/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.tfclunchbox.container;

import dev.thomas.tfclunchbox.container.AbstractLunchboxContainer;
import dev.thomas.tfclunchbox.container.ModContainers;
import dev.thomas.tfclunchbox.item.SimpleLunchboxItem;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodTrait;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;

public class SimpleLunchboxContainer
extends AbstractLunchboxContainer {
    public SimpleLunchboxContainer(int windowId, Inventory playerInventory, ItemStack lunchbox, InteractionHand hand) {
        super((MenuType)ModContainers.SIMPLE_LUNCHBOX_CONTAINER.get(), windowId, playerInventory, lunchbox, hand, 9);
    }

    public SimpleLunchboxContainer(int windowId, Inventory playerInventory, FriendlyByteBuf buf) {
        super((MenuType)ModContainers.SIMPLE_LUNCHBOX_CONTAINER.get(), windowId, playerInventory, buf, 9);
    }

    @Override
    protected ItemStackHandler createItemHandler() {
        return new ItemStackHandler(9){
            private boolean isUpdating;
            {
                this.isUpdating = false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onContentsChanged(int slot) {
                if (this.isUpdating) {
                    return;
                }
                this.isUpdating = true;
                try {
                    super.onContentsChanged(slot);
                    SimpleLunchboxContainer.this.saveItems();
                    for (int i = 0; i < 9; ++i) {
                        ItemStack food = this.getStackInSlot(i);
                        if (food.m_41619_() || !SimpleLunchboxItem.checkItemValid(food)) continue;
                        FoodCapability.applyTrait((ItemStack)food, (FoodTrait)SimpleLunchboxItem.getLunchboxPreservedTrait());
                    }
                }
                finally {
                    this.isUpdating = false;
                }
            }
        };
    }

    @Override
    protected void setupSlots(Inventory playerInventory) {
        int startX = 62;
        int startY = 17;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                this.m_38897_((Slot)new AbstractLunchboxContainer.FoodSlot(this.itemHandler, row * 3 + col, startX + col * 18, startY + row * 18));
            }
        }
        this.addPlayerInventorySlots(playerInventory);
    }

    @Override
    protected boolean checkItemValid(ItemStack stack) {
        return SimpleLunchboxItem.checkItemValid(stack);
    }

    @Override
    protected FoodTrait getFoodTrait() {
        return SimpleLunchboxItem.getLunchboxPreservedTrait();
    }

    @Override
    protected Class<?> getLunchboxClass() {
        return SimpleLunchboxItem.class;
    }

    @Override
    protected void updateFoodTraits() {
        for (int i = 0; i < 9; ++i) {
            ItemStack food = this.itemHandler.getStackInSlot(i);
            if (food.m_41619_() || !SimpleLunchboxItem.checkItemValid(food)) continue;
            FoodCapability.applyTrait((ItemStack)food, (FoodTrait)SimpleLunchboxItem.getLunchboxPreservedTrait());
        }
    }

    @Override
    protected int getAdditionalSlots() {
        return 0;
    }
}

