/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.tfclunchbox.integration;

import dev.thomas.tfclunchbox.integration.GregTechIntegration;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class GregTechCellHelper {
    private static final String GTCEU_MODID = "gtceu";
    private static final String ICE_FLUID_NAME = "gtceu:ice";
    private static final List<String> FLUID_CELL_IDS = Arrays.asList("universal_fluid_cell", "fluid_cell", "steel_fluid_cell", "aluminium_fluid_cell", "stainless_steel_fluid_cell", "titanium_fluid_cell", "tungstensteel_fluid_cell", "glass_vial");

    public static boolean isUniversalCell(ItemStack stack) {
        if (!GregTechIntegration.isGregTechLoaded()) {
            return false;
        }
        try {
            if (!GregTechCellHelper.isGregTechFluidCell(stack)) {
                return false;
            }
            return GregTechCellHelper.containsIceFluid(stack);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isGregTechFluidCell(ItemStack stack) {
        for (String cellId : FLUID_CELL_IDS) {
            Item cell = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(GTCEU_MODID, cellId));
            if (cell == null || stack.m_41720_() != cell) continue;
            return true;
        }
        return false;
    }

    private static boolean containsIceFluid(ItemStack stack) {
        if (GregTechCellHelper.isUniversalCellWithIce(stack)) {
            return true;
        }
        return GregTechCellHelper.isRegularFluidCellWithIce(stack);
    }

    private static boolean isUniversalCellWithIce(ItemStack stack) {
        if (!stack.m_41782_()) {
            return false;
        }
        CompoundTag tag = stack.m_41783_();
        if (!tag.m_128441_("Fluid")) {
            return false;
        }
        CompoundTag fluidTag = tag.m_128469_("Fluid");
        if (!fluidTag.m_128441_("FluidName")) {
            return false;
        }
        String fluidName = fluidTag.m_128461_("FluidName");
        return ICE_FLUID_NAME.equals(fluidName);
    }

    private static boolean isRegularFluidCellWithIce(ItemStack stack) {
        try {
            Class<?> helperClass = Class.forName("com.lowdragmc.lowdraglib.side.fluid.FluidTransferHelper");
            Method getFluidContainedMethod = helperClass.getMethod("getFluidContained", ItemStack.class);
            Object fluidStack = getFluidContainedMethod.invoke(null, stack);
            if (fluidStack == null) {
                return false;
            }
            Method getFluidMethod = fluidStack.getClass().getMethod("getFluid", new Class[0]);
            Object fluid = getFluidMethod.invoke(fluidStack, new Object[0]);
            Method getRegistryNameMethod = fluid.getClass().getMethod("getRegistryName", new Class[0]);
            Object registryName = getRegistryNameMethod.invoke(fluid, new Object[0]);
            if (registryName != null) {
                return ICE_FLUID_NAME.equals(registryName.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isFilledCell(ItemStack stack) {
        return GregTechCellHelper.isUniversalCell(stack) && GregTechCellHelper.getFluidAmount(stack) > 0;
    }

    public static int getCellDurability(ItemStack stack) {
        if (!GregTechCellHelper.isUniversalCell(stack)) {
            return 0;
        }
        return GregTechCellHelper.getFluidAmount(stack);
    }

    private static int getFluidAmount(ItemStack stack) {
        int nbtAmount = GregTechCellHelper.getNBTFluidAmount(stack);
        if (nbtAmount > 0) {
            return nbtAmount;
        }
        return GregTechCellHelper.getFluidTransferAmount(stack);
    }

    private static int getNBTFluidAmount(ItemStack stack) {
        if (!stack.m_41782_()) {
            return 0;
        }
        CompoundTag tag = stack.m_41783_();
        if (!tag.m_128441_("Fluid")) {
            return 0;
        }
        CompoundTag fluidTag = tag.m_128469_("Fluid");
        return fluidTag.m_128451_("Amount");
    }

    private static int getFluidTransferAmount(ItemStack stack) {
        try {
            Class<?> helperClass = Class.forName("com.lowdragmc.lowdraglib.side.fluid.FluidTransferHelper");
            Method getFluidContainedMethod = helperClass.getMethod("getFluidContained", ItemStack.class);
            Object fluidStack = getFluidContainedMethod.invoke(null, stack);
            if (fluidStack != null) {
                Method getAmountMethod = fluidStack.getClass().getMethod("getAmount", new Class[0]);
                Object amount = getAmountMethod.invoke(fluidStack, new Object[0]);
                if (amount instanceof Integer) {
                    return (Integer)amount;
                }
                if (amount instanceof Long) {
                    return ((Long)amount).intValue();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public static void consumeCell(ItemStack stack) {
        if (!GregTechCellHelper.isFilledCell(stack)) {
            return;
        }
        if (GregTechCellHelper.consumeFromNBT(stack)) {
            return;
        }
        GregTechCellHelper.consumeFromFluidTransfer(stack);
    }

    private static boolean consumeFromNBT(ItemStack stack) {
        try {
            CompoundTag tag = stack.m_41783_();
            if (tag == null || !tag.m_128441_("Fluid")) {
                return false;
            }
            CompoundTag fluidTag = tag.m_128469_("Fluid");
            int currentAmount = fluidTag.m_128451_("Amount");
            if (currentAmount > 1) {
                fluidTag.m_128405_("Amount", currentAmount - 1);
                tag.m_128365_("Fluid", (Tag)fluidTag);
            } else {
                tag.m_128473_("Fluid");
                if (tag.m_128456_()) {
                    stack.m_41751_(null);
                }
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void consumeFromFluidTransfer(ItemStack stack) {
        try {
            Class<?> transferClass = Class.forName("com.lowdragmc.lowdraglib.misc.ItemStackTransfer");
            Object transfer = transferClass.getConstructor(ItemStack.class).newInstance(stack);
            Class<?> helperClass = Class.forName("com.lowdragmc.lowdraglib.side.fluid.FluidTransferHelper");
            Method getFluidTransferMethod = helperClass.getMethod("getFluidTransfer", transferClass, Integer.TYPE);
            Object fluidTransfer = getFluidTransferMethod.invoke(null, transfer, 0);
            if (fluidTransfer != null) {
                Method drainMethod = fluidTransfer.getClass().getMethod("drain", Long.TYPE, Boolean.TYPE);
                drainMethod.invoke(fluidTransfer, 1L, false);
                Method getStackMethod = transferClass.getMethod("getStackInSlot", Integer.TYPE);
                ItemStack updatedStack = (ItemStack)getStackMethod.invoke(transfer, 0);
                stack.m_41751_(updatedStack.m_41783_());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isBarVisible(ItemStack stack) {
        return GregTechCellHelper.isUniversalCell(stack) && GregTechCellHelper.getFluidAmount(stack) > 0;
    }

    public static int getBarWidth(ItemStack stack) {
        if (!GregTechCellHelper.isUniversalCell(stack)) {
            return 0;
        }
        int currentAmount = GregTechCellHelper.getFluidAmount(stack);
        int maxAmount = GregTechCellHelper.getMaxFluidAmount(stack);
        if (maxAmount <= 0) {
            return 0;
        }
        return Math.round((float)currentAmount * 13.0f / (float)maxAmount);
    }

    public static int getBarColor(ItemStack stack) {
        if (!GregTechCellHelper.isUniversalCell(stack)) {
            return 65280;
        }
        int currentAmount = GregTechCellHelper.getFluidAmount(stack);
        int maxAmount = GregTechCellHelper.getMaxFluidAmount(stack);
        if (maxAmount <= 0) {
            return 65280;
        }
        float durabilityRatio = (float)currentAmount / (float)maxAmount;
        if (durabilityRatio > 0.5f) {
            int green = 255;
            int red = (int)(255.0f * (1.0f - durabilityRatio) * 2.0f);
            return red << 16 | green << 8 | 0;
        }
        int red = 255;
        int green = (int)(255.0f * durabilityRatio * 2.0f);
        return red << 16 | green << 8 | 0;
    }

    private static int getMaxFluidAmount(ItemStack stack) {
        if (!GregTechCellHelper.isGregTechFluidCell(stack)) {
            return 0;
        }
        String cellType = GregTechCellHelper.getCellType(stack);
        if (cellType == null) {
            return 1000;
        }
        switch (cellType) {
            case "universal_fluid_cell": {
                return 1000;
            }
            case "fluid_cell": {
                return 1000;
            }
            case "steel_fluid_cell": {
                return 8000;
            }
            case "aluminium_fluid_cell": {
                return 32000;
            }
            case "stainless_steel_fluid_cell": {
                return 64000;
            }
            case "titanium_fluid_cell": {
                return 128000;
            }
            case "tungstensteel_fluid_cell": {
                return 512000;
            }
            case "glass_vial": {
                return 1000;
            }
        }
        return 1000;
    }

    private static String getCellType(ItemStack stack) {
        for (String cellId : FLUID_CELL_IDS) {
            Item cell = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(GTCEU_MODID, cellId));
            if (cell == null || stack.m_41720_() != cell) continue;
            return cellId;
        }
        return null;
    }

    public static ItemStack createFilledCell(ItemStack emptyCell, String fluidName, int amount) {
        if (emptyCell.m_41619_() || !ICE_FLUID_NAME.equals(fluidName)) {
            return ItemStack.f_41583_;
        }
        ItemStack filledCell = emptyCell.m_41777_();
        CompoundTag fluidTag = new CompoundTag();
        fluidTag.m_128359_("FluidName", fluidName);
        fluidTag.m_128405_("Amount", amount);
        CompoundTag itemTag = filledCell.m_41784_();
        itemTag.m_128365_("Fluid", (Tag)fluidTag);
        return filledCell;
    }
}

