/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.tfclunchbox.item;

import java.util.HashSet;
import net.dries007.tfc.common.capabilities.food.DynamicBowlHandler;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.IFood;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public abstract class BaseLunchboxItem
extends Item {
    public static final int FOOD_SLOTS = 9;
    public static final TagKey<Item> LUNCHBOX_WHITELIST = ItemTags.create((ResourceLocation)new ResourceLocation("tfclunchbox", "lunchbox_whitelisted"));
    public static final TagKey<Item> LUNCHBOX_BLACKLIST = ItemTags.create((ResourceLocation)new ResourceLocation("tfclunchbox", "lunchbox_blacklisted"));

    protected BaseLunchboxItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public static boolean checkItemValid(ItemStack stack, Class<?> ... excludedClasses) {
        if (stack.m_41619_()) {
            return false;
        }
        for (Class<?> excludedClass : excludedClasses) {
            if (!excludedClass.isInstance(stack.m_41720_())) continue;
            return false;
        }
        return (stack.m_41614_() || stack.m_204117_(LUNCHBOX_WHITELIST)) && !stack.m_204117_(LUNCHBOX_BLACKLIST) && stack.m_41720_().m_142095_();
    }

    protected void removeIgnoredTags(CompoundTag tag, String ... additionalTags) {
        tag.m_128473_("Items");
        tag.m_128473_("SelectedSlot");
        tag.m_128473_("isOpen");
        tag.m_128473_("isClosed");
        for (String additionalTag : additionalTags) {
            tag.m_128473_(additionalTag);
        }
        if (tag.m_128441_("ForgeCaps")) {
            tag.m_128473_("ForgeCaps");
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (oldStack.m_41720_() != newStack.m_41720_() || slotChanged) {
            return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
        }
        ItemStack oldCopy = oldStack.m_41777_();
        ItemStack newCopy = newStack.m_41777_();
        this.removeIgnoredTags(oldCopy.m_41784_(), this.getAdditionalIgnoredTags());
        this.removeIgnoredTags(newCopy.m_41784_(), this.getAdditionalIgnoredTags());
        return !ItemStack.m_41728_((ItemStack)oldCopy, (ItemStack)newCopy);
    }

    public int m_8105_(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("Items") && tag.m_128441_(this.getEatSlotTag())) {
            ItemStack food;
            ItemStackHandler handler = new ItemStackHandler(9);
            handler.deserializeNBT(tag.m_128469_("Items"));
            int eatSlot = tag.m_128451_(this.getEatSlotTag());
            if (eatSlot >= 0 && eatSlot < 9 && !(food = handler.getStackInSlot(eatSlot)).m_41619_() && food.m_41614_()) {
                return food.m_41779_();
            }
        }
        return 32;
    }

    @NotNull
    public UseAnim m_6164_(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("Items") && tag.m_128441_(this.getEatSlotTag())) {
            ItemStack food;
            ItemStackHandler handler = new ItemStackHandler(9);
            handler.deserializeNBT(tag.m_128469_("Items"));
            int eatSlot = tag.m_128451_(this.getEatSlotTag());
            if (eatSlot >= 0 && eatSlot < 9 && !(food = handler.getStackInSlot(eatSlot)).m_41619_() && food.m_41614_()) {
                return food.m_41780_();
            }
        }
        return UseAnim.NONE;
    }

    public void m_5551_(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity entity, int timeLeft) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128473_(this.getEatSlotTag());
        tag.m_128379_("IsOpen", false);
        stack.m_41751_(tag);
        super.m_5551_(stack, level, entity, timeLeft);
    }

    public void m_7836_(@NotNull ItemStack stack, @NotNull Level level, @NotNull Player player) {
        super.m_7836_(stack, level, player);
        stack.m_41784_().m_128405_("SelectedSlot", 0);
    }

    protected boolean handleEating(ItemStack stack, Level level, Player player, int eatSlot) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("Items")) {
            ItemStack food;
            ItemStackHandler handler = new ItemStackHandler(9);
            handler.deserializeNBT(tag.m_128469_("Items"));
            if (eatSlot >= 0 && eatSlot < 9 && !(food = handler.getStackInSlot(eatSlot)).m_41619_() && food.m_41614_() && player.m_36391_(food.getFoodProperties((LivingEntity)player) != null ? food.getFoodProperties((LivingEntity)player).m_38747_() : false)) {
                ItemStack originalFood = food.m_41777_();
                IFood foodCap = originalFood.getCapability(FoodCapability.CAPABILITY).resolve().orElse(null);
                ItemStack result = food.m_41671_(level, (LivingEntity)player);
                if (foodCap instanceof DynamicBowlHandler) {
                    ItemStack bowlResult = DynamicBowlHandler.onItemUse((ItemStack)originalFood, (ItemStack)result, (LivingEntity)player);
                    if (!bowlResult.m_41619_() && bowlResult != result && !player.m_150109_().m_36054_(bowlResult)) {
                        player.m_36176_(bowlResult, false);
                    }
                } else if (originalFood.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("tfc", "dynamic_bowl_items")))) {
                    ItemStack bowl = new ItemStack((ItemLike)Items.f_42399_);
                    if (!player.m_150109_().m_36054_(bowl)) {
                        player.m_36176_(bowl, false);
                    }
                }
                if (result.m_41619_()) {
                    handler.setStackInSlot(eatSlot, ItemStack.f_41583_);
                } else {
                    handler.setStackInSlot(eatSlot, result);
                }
                tag.m_128365_("Items", (Tag)handler.serializeNBT());
                tag.m_128473_(this.getEatSlotTag());
                tag.m_128379_("IsOpen", false);
                stack.m_41751_(tag);
                return true;
            }
            tag.m_128473_(this.getEatSlotTag());
            tag.m_128379_("IsOpen", false);
        }
        return false;
    }

    public static void cleanFoodNBT(ItemStack food) {
        CompoundTag tag = food.m_41783_();
        if (tag != null) {
            HashSet keys = new HashSet(tag.m_128431_());
            for (String key : keys) {
                if (key.equals("decay") || key.equals("food") || key.equals("Traits")) continue;
                tag.m_128473_(key);
            }
            if (tag.m_128456_()) {
                food.m_41751_(null);
            }
        }
    }

    protected abstract String getEatSlotTag();

    protected abstract String[] getAdditionalIgnoredTags();

    protected abstract Class<?>[] getExcludedClasses();
}

