/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.tfclunchbox.item;

import dev.thomas.tfclunchbox.item.CoolingLunchboxItem;
import dev.thomas.tfclunchbox.item.UniversalCapsuleItem;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;

public class CoolingLunchboxCapabilityProvider
implements ICapabilityProvider {
    private static final TagKey<Item> ICE_TAG = ItemTags.create((ResourceLocation)new ResourceLocation("tfclunchbox", "ice"));
    public static final Predicate<ItemStack> ICE_VALIDATOR = stack -> stack.m_204117_(ICE_TAG);
    private final ItemStackHandler itemHandler;
    private final LazyOptional<ItemStackHandler> capability;
    private final int iceSlotsStart;

    public CoolingLunchboxCapabilityProvider(ItemStack stack) {
        this.iceSlotsStart = 9;
        this.itemHandler = this.createHandler(stack);
        this.capability = LazyOptional.of(() -> this.itemHandler);
    }

    private ItemStackHandler createHandler(final ItemStack container) {
        return new ItemStackHandler(12){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (slot < 9) {
                    return CoolingLunchboxItem.checkItemValid(stack);
                }
                if (slot == 9) {
                    return ICE_VALIDATOR.test(stack) || stack.m_41720_() instanceof UniversalCapsuleItem;
                }
                return false;
            }

            protected void onContentsChanged(int slot) {
                CompoundTag containerTag = container.m_41784_();
                containerTag.m_128365_("Items", (Tag)this.serializeNBT());
                container.m_41751_(containerTag);
            }

            public CompoundTag serializeNBT() {
                CompoundTag tag = super.serializeNBT();
                return tag;
            }

            public void deserializeNBT(CompoundTag nbt) {
                super.deserializeNBT(nbt);
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.capability.cast();
        }
        return LazyOptional.empty();
    }

    public void invalidate() {
        this.capability.invalidate();
    }

    public void loadNBT(CompoundTag nbt) {
        this.itemHandler.deserializeNBT(nbt.m_128469_("Items"));
    }
}

