/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.tfclunchbox.item;

import dev.thomas.tfclunchbox.container.CoolingLunchboxContainer;
import dev.thomas.tfclunchbox.integration.GregTechCellHelper;
import dev.thomas.tfclunchbox.item.BaseLunchboxItem;
import dev.thomas.tfclunchbox.item.CoolingLunchboxCapabilityProvider;
import dev.thomas.tfclunchbox.item.UniversalCapsuleItem;
import dev.thomas.tfclunchbox.util.ClientUtils;
import java.util.LinkedHashMap;
import java.util.List;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodTrait;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoolingLunchboxItem
extends BaseLunchboxItem {
    public static final int FOOD_SLOTS = 9;
    public static final int ICE_SLOT_UPPER = 0;
    public static final int ICE_SLOT_MIDDLE = 1;
    public static final int CAPSULE_SLOT = 2;
    private static final String ICE_DURABILITY_TAG = "IceDurability";
    public static final int MAX_ICE_DURABILITY = 100;
    private static final String EAT_SLOT_TAG = "LunchboxEatSlot";
    public static final TagKey<Item> LUNCHBOX_WHITELIST = ItemTags.create((ResourceLocation)new ResourceLocation("tfclunchbox", "lunchbox_whitelisted"));
    public static final TagKey<Item> LUNCHBOX_BLACKLIST = ItemTags.create((ResourceLocation)new ResourceLocation("tfclunchbox", "lunchbox_blacklisted"));
    public static final FoodTrait LUNCHBOX_COOLED = FoodTrait.register((ResourceLocation)new ResourceLocation("tfclunchbox", "lunchbox_cooled"), (FoodTrait)new FoodTrait(0.3f, "tooltip.tfclunchbox.food_trait.lunchbox_cooled"));

    public static FoodTrait getLunchboxCooledTrait() {
        return LUNCHBOX_COOLED;
    }

    public static boolean checkItemValid(ItemStack stack) {
        return BaseLunchboxItem.checkItemValid(stack, CoolingLunchboxItem.class);
    }

    public CoolingLunchboxItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            if (!level.m_5776_()) {
                stack.m_41784_().m_128379_("IsOpen", true);
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((windowId, playerInventory, _player) -> new CoolingLunchboxContainer(windowId, playerInventory, stack, hand), (Component)Component.m_237115_((String)"container.tfclunchbox.cooling_lunchbox").m_130940_(ChatFormatting.GOLD)), buf -> {
                    buf.m_130055_(stack);
                    buf.m_130068_((Enum)hand);
                    int encodedSlot = hand == InteractionHand.OFF_HAND ? -1 : player.m_150109_().f_35977_;
                    buf.writeByte(encodedSlot);
                });
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("Items")) {
            ItemStack food;
            int selectedSlot;
            ItemStackHandler handler = new ItemStackHandler(9);
            handler.deserializeNBT(tag.m_128469_("Items"));
            int n = selectedSlot = tag.m_128441_("SelectedSlot") ? tag.m_128451_("SelectedSlot") : 0;
            if (selectedSlot < 0 || selectedSlot >= 9) {
                selectedSlot = 0;
                tag.m_128405_("SelectedSlot", selectedSlot);
            }
            if (!(food = handler.getStackInSlot(selectedSlot)).m_41619_() && food.m_41614_() && player.m_36391_(food.getFoodProperties((LivingEntity)player) != null ? food.getFoodProperties((LivingEntity)player).m_38747_() : false)) {
                tag.m_128405_(EAT_SLOT_TAG, selectedSlot);
                tag.m_128379_("IsOpen", true);
                stack.m_41751_(tag);
                player.m_6672_(hand);
                return InteractionResultHolder.m_19096_((Object)stack);
            }
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity entity) {
        int eatSlot;
        if (!(entity instanceof Player)) {
            return stack;
        }
        Player player = (Player)entity;
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("Items") && tag.m_128441_(EAT_SLOT_TAG) && this.handleEating(stack, level, player, eatSlot = tag.m_128451_(EAT_SLOT_TAG))) {
            ItemStackHandler fullHandler = new ItemStackHandler(12);
            fullHandler.deserializeNBT(tag.m_128469_("Items"));
            ItemStack ice = fullHandler.getStackInSlot(10);
            if (!ice.m_41619_()) {
                if (ice.m_41720_() instanceof UniversalCapsuleItem) {
                    int durability = UniversalCapsuleItem.getDurability(ice);
                    if (durability > 0) {
                        UniversalCapsuleItem.setDurability(ice, durability - 1);
                        if (durability <= 1) {
                            fullHandler.setStackInSlot(11, ice);
                            fullHandler.setStackInSlot(10, ItemStack.f_41583_);
                        } else {
                            fullHandler.setStackInSlot(10, ice);
                        }
                    }
                } else if (GregTechCellHelper.isUniversalCell(ice)) {
                    int durability = GregTechCellHelper.getCellDurability(ice);
                    if (durability > 0) {
                        GregTechCellHelper.consumeCell(ice);
                        if (GregTechCellHelper.getCellDurability(ice) <= 0) {
                            fullHandler.setStackInSlot(11, ice);
                            fullHandler.setStackInSlot(10, ItemStack.f_41583_);
                        } else {
                            fullHandler.setStackInSlot(10, ice);
                        }
                    }
                } else {
                    CompoundTag iceTag = ice.m_41784_();
                    int durability = iceTag.m_128451_(ICE_DURABILITY_TAG);
                    if (durability == 0) {
                        durability = 100;
                    }
                    if (--durability <= 0) {
                        fullHandler.setStackInSlot(10, ItemStack.f_41583_);
                    } else {
                        iceTag.m_128405_(ICE_DURABILITY_TAG, durability);
                        ice.m_41751_(iceTag);
                        fullHandler.setStackInSlot(10, ice);
                    }
                }
                tag.m_128365_("Items", (Tag)fullHandler.serializeNBT());
                stack.m_41751_(tag);
            }
            return stack;
        }
        return stack;
    }

    public void m_6883_(@NotNull ItemStack stack, Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        CompoundTag tag;
        if (!level.m_5776_() && entity instanceof Player && (tag = stack.m_41784_()).m_128441_("Items")) {
            int durability;
            ItemStackHandler handler = new ItemStackHandler(12);
            handler.deserializeNBT(tag.m_128469_("Items"));
            ItemStack upperIce = handler.getStackInSlot(9);
            ItemStack middleIce = handler.getStackInSlot(10);
            ItemStack capsule = handler.getStackInSlot(11);
            boolean hasIce = false;
            if (!middleIce.m_41619_()) {
                hasIce = middleIce.m_41720_() instanceof UniversalCapsuleItem ? UniversalCapsuleItem.getDurability(middleIce) > 0 : (GregTechCellHelper.isUniversalCell(middleIce) ? GregTechCellHelper.getCellDurability(middleIce) > 0 : true);
            }
            boolean needsUpdate = false;
            boolean hasFood = false;
            for (int i = 0; i < 9; ++i) {
                ItemStack food = handler.getStackInSlot(i);
                if (food.m_41619_() || !CoolingLunchboxItem.checkItemValid(food)) continue;
                hasFood = true;
                if (hasIce) {
                    FoodCapability.applyTrait((ItemStack)food, (FoodTrait)CoolingLunchboxItem.getLunchboxCooledTrait());
                } else {
                    FoodCapability.removeTrait((ItemStack)food, (FoodTrait)CoolingLunchboxItem.getLunchboxCooledTrait());
                }
                handler.setStackInSlot(i, food);
                needsUpdate = true;
            }
            if (!upperIce.m_41619_() && middleIce.m_41619_() && capsule.m_41619_()) {
                if (upperIce.m_41720_() instanceof UniversalCapsuleItem) {
                    durability = UniversalCapsuleItem.getDurability(upperIce);
                    if (durability > 0) {
                        handler.setStackInSlot(10, upperIce.m_41620_(1));
                    } else {
                        handler.setStackInSlot(11, upperIce.m_41620_(1));
                    }
                } else if (GregTechCellHelper.isUniversalCell(upperIce)) {
                    durability = GregTechCellHelper.getCellDurability(upperIce);
                    if (durability > 0) {
                        handler.setStackInSlot(10, upperIce.m_41620_(1));
                    } else {
                        handler.setStackInSlot(11, upperIce.m_41620_(1));
                    }
                } else {
                    handler.setStackInSlot(10, upperIce.m_41620_(1));
                }
                needsUpdate = true;
            }
            if (!middleIce.m_41619_() && hasFood) {
                if (middleIce.m_41720_() instanceof UniversalCapsuleItem) {
                    durability = UniversalCapsuleItem.getDurability(middleIce);
                    if (durability > 0 && level.m_213780_().m_188501_() < 0.003f) {
                        UniversalCapsuleItem.setDurability(middleIce, durability - 1);
                        if (durability <= 1) {
                            handler.setStackInSlot(11, middleIce);
                            handler.setStackInSlot(10, ItemStack.f_41583_);
                        }
                        needsUpdate = true;
                    }
                } else if (GregTechCellHelper.isUniversalCell(middleIce)) {
                    durability = GregTechCellHelper.getCellDurability(middleIce);
                    if (durability > 0 && level.m_213780_().m_188501_() < 0.003f) {
                        GregTechCellHelper.consumeCell(middleIce);
                        if (GregTechCellHelper.getCellDurability(middleIce) <= 0) {
                            handler.setStackInSlot(11, middleIce);
                            handler.setStackInSlot(10, ItemStack.f_41583_);
                        }
                        needsUpdate = true;
                    }
                } else {
                    CompoundTag iceTag = middleIce.m_41784_();
                    int durability2 = iceTag.m_128451_(ICE_DURABILITY_TAG);
                    if (durability2 == 0) {
                        durability2 = 100;
                        iceTag.m_128405_(ICE_DURABILITY_TAG, durability2);
                        middleIce.m_41751_(iceTag);
                        needsUpdate = true;
                    }
                    if (durability2 > 0 && level.m_213780_().m_188501_() < 0.005f) {
                        iceTag.m_128405_(ICE_DURABILITY_TAG, --durability2);
                        middleIce.m_41751_(iceTag);
                        if (durability2 <= 0) {
                            handler.setStackInSlot(10, ItemStack.f_41583_);
                        }
                        needsUpdate = true;
                    }
                }
            }
            if (needsUpdate) {
                tag.m_128365_("Items", (Tag)handler.serializeNBT());
                stack.m_41751_(tag);
            }
        }
    }

    @javax.annotation.Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @javax.annotation.Nullable CompoundTag nbt) {
        CoolingLunchboxCapabilityProvider provider = new CoolingLunchboxCapabilityProvider(stack);
        if (nbt != null && nbt.m_128441_("Items")) {
            provider.loadNBT(nbt);
        } else {
            CompoundTag tag = stack.m_41784_();
            if (!tag.m_128441_("SelectedSlot")) {
                tag.m_128405_("SelectedSlot", 0);
            }
        }
        return provider;
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (oldStack.m_41720_() != newStack.m_41720_() || slotChanged) {
            return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
        }
        ItemStack oldCopy = oldStack.m_41777_();
        ItemStack newCopy = newStack.m_41777_();
        this.removeIgnoredTags(oldCopy.m_41784_(), this.getAdditionalIgnoredTags());
        this.removeIgnoredTags(newCopy.m_41784_(), this.getAdditionalIgnoredTags());
        return !ItemStack.m_41728_((ItemStack)oldCopy, (ItemStack)newCopy);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag flag) {
        components.add((Component)Component.m_237115_((String)"item.tfclunchbox.cooling_lunchbox.main").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC}));
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("Items")) {
            ItemStackHandler handler = new ItemStackHandler(12);
            handler.deserializeNBT(tag.m_128469_("Items"));
            ItemStack middleIce = handler.getStackInSlot(10);
            ItemStack capsule = handler.getStackInSlot(11);
            boolean hasIce = false;
            if (!middleIce.m_41619_()) {
                hasIce = middleIce.m_41720_() instanceof UniversalCapsuleItem ? UniversalCapsuleItem.getDurability(middleIce) > 0 : (GregTechCellHelper.isUniversalCell(middleIce) ? GregTechCellHelper.getCellDurability(middleIce) > 0 : true);
            }
            components.add((Component)Component.m_237115_((String)"tooltip.tfclunchbox.contents").m_130940_(ChatFormatting.GOLD));
            LinkedHashMap<String, FoodInfo> foodMap = new LinkedHashMap<String, FoodInfo>();
            for (int i = 0; i < 9; ++i) {
                ItemStack food = handler.getStackInSlot(i);
                if (food.m_41619_() || !food.m_41614_()) continue;
                String name = food.m_41786_().getString();
                FoodInfo info = foodMap.getOrDefault(name, new FoodInfo(name, 0, hasIce));
                info.count += food.m_41613_();
                foodMap.put(name, info);
            }
            if (foodMap.isEmpty()) {
                components.add((Component)Component.m_237113_((String)"  ").m_7220_((Component)Component.m_237115_((String)"tooltip.tfclunchbox.empty")).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            } else {
                for (FoodInfo info : foodMap.values()) {
                    if (info.isCooled) {
                        MutableComponent foodComponent = Component.m_237113_((String)(" \u2022 " + info.name + " x" + info.count)).m_130940_(ChatFormatting.AQUA);
                        foodComponent = foodComponent.m_7220_((Component)Component.m_237113_((String)" \u2744").m_130940_(ChatFormatting.BLUE));
                        components.add((Component)foodComponent);
                        continue;
                    }
                    components.add((Component)Component.m_237113_((String)(" \u2022 " + info.name + " x" + info.count)).m_130940_(ChatFormatting.WHITE));
                }
                if (hasIce) {
                    components.add((Component)Component.m_237115_((String)"tooltip.tfclunchbox.cooling_active").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
                } else {
                    components.add((Component)Component.m_237115_((String)"tooltip.tfclunchbox.cooling_inactive").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
                }
            }
        }
        if (ClientUtils.isShiftDown()) {
            components.add((Component)Component.m_237115_((String)"tooltip.tfclunchbox.cooling_lunchbox.shift_info").m_130940_(ChatFormatting.GRAY));
        } else {
            components.add((Component)Component.m_237115_((String)"tooltip.tfclunchbox.cooling_lunchbox.hold_shift").m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    @Override
    protected String getEatSlotTag() {
        return EAT_SLOT_TAG;
    }

    @Override
    protected String[] getAdditionalIgnoredTags() {
        return new String[]{ICE_DURABILITY_TAG};
    }

    @Override
    protected Class<?>[] getExcludedClasses() {
        return new Class[]{CoolingLunchboxItem.class};
    }

    private static class FoodInfo {
        String name;
        int count;
        boolean isCooled;

        FoodInfo(String name, int count, boolean isCooled) {
            this.name = name;
            this.count = count;
            this.isCooled = isCooled;
        }
    }
}

