/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.tfclunchbox.item;

import dev.thomas.tfclunchbox.item.ElectricLunchboxItem;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;

public class ElectricLunchboxCapabilityProvider
implements ICapabilityProvider {
    public static final Predicate<ItemStack> BATTERY_VALIDATOR = ElectricLunchboxItem::isBattery;
    private final ItemStackHandler itemHandler;
    private final LazyOptional<ItemStackHandler> capability;

    public ElectricLunchboxCapabilityProvider(ItemStack stack) {
        this.itemHandler = this.createHandler(stack);
        this.capability = LazyOptional.of(() -> this.itemHandler);
    }

    private ItemStackHandler createHandler(final ItemStack container) {
        return new ItemStackHandler(10){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (slot < 9) {
                    return ElectricLunchboxItem.checkItemValid(stack);
                }
                if (slot == 9) {
                    return BATTERY_VALIDATOR.test(stack);
                }
                return false;
            }

            protected void onContentsChanged(int slot) {
                CompoundTag containerTag = container.m_41784_();
                containerTag.m_128365_("Items", (Tag)this.serializeNBT());
                container.m_41751_(containerTag);
            }

            public CompoundTag serializeNBT() {
                CompoundTag tag = super.serializeNBT();
                return tag;
            }

            public void deserializeNBT(CompoundTag nbt) {
                super.deserializeNBT(nbt);
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.capability.cast();
        }
        return LazyOptional.empty();
    }

    public void invalidate() {
        this.capability.invalidate();
    }
}

