/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.tfclunchbox.item;

import dev.thomas.tfclunchbox.TFCLunchBox;
import dev.thomas.tfclunchbox.container.ElectricLunchboxContainer;
import dev.thomas.tfclunchbox.integration.GregTechIntegration;
import dev.thomas.tfclunchbox.item.BaseLunchboxItem;
import dev.thomas.tfclunchbox.item.CoolingLunchboxItem;
import dev.thomas.tfclunchbox.item.ElectricLunchboxCapabilityProvider;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodTrait;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElectricLunchboxItem
extends BaseLunchboxItem {
    public static final int BATTERY_SLOT = 0;
    private static final String ENERGY_TAG = "Energy";
    private static final String EAT_SLOT_TAG = "LunchboxEatSlot";
    public static final long MAX_ENERGY = 8000L;
    public static final long ENERGY_PER_TICK = 1L;
    public static final TagKey<Item> ELECTRIC_BATTERIES = ItemTags.create((ResourceLocation)new ResourceLocation("tfclunchbox", "electric_batteries"));

    public static FoodTrait getLunchboxCooledTrait() {
        return CoolingLunchboxItem.getLunchboxCooledTrait();
    }

    public static boolean checkItemValid(ItemStack stack) {
        return BaseLunchboxItem.checkItemValid(stack, ElectricLunchboxItem.class);
    }

    public ElectricLunchboxItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public void m_7836_(@NotNull ItemStack stack, @NotNull Level level, @NotNull Player player) {
        super.m_7836_(stack, level, player);
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_("LunchboxType", "electric");
        tag.m_128359_("LunchboxUUID", UUID.randomUUID().toString());
        stack.m_41751_(tag);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        if (!GregTechIntegration.isGregTechLoaded()) {
            if (level.f_46443_) {
                player.m_5661_((Component)Component.m_237115_((String)"message.tfclunchbox.gregtech_required").m_130940_(ChatFormatting.RED), true);
            }
            return InteractionResultHolder.m_19100_((Object)player.m_21120_(hand));
        }
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            if (!level.f_46443_ && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CompoundTag tag = stack.m_41784_();
                tag.m_128379_("IsOpen", true);
                stack.m_41751_(tag);
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider((windowId, playerInventory, _player) -> new ElectricLunchboxContainer(windowId, playerInventory, stack, hand), (Component)Component.m_237115_((String)"container.tfclunchbox.electric_lunchbox").m_130940_(ChatFormatting.GOLD)), buf -> {
                    buf.m_130055_(stack);
                    buf.m_130068_((Enum)hand);
                    int encodedSlot = hand == InteractionHand.OFF_HAND ? -1 : player.m_150109_().f_35977_;
                    buf.writeByte(encodedSlot);
                });
            }
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
        }
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("Items")) {
            ItemStack food;
            int selectedSlot;
            ItemStackHandler handler = new ItemStackHandler(10);
            handler.deserializeNBT(tag.m_128469_("Items"));
            int n = selectedSlot = tag.m_128441_("SelectedSlot") ? tag.m_128451_("SelectedSlot") : 0;
            if (selectedSlot < 0 || selectedSlot >= 9) {
                selectedSlot = 0;
                tag.m_128405_("SelectedSlot", selectedSlot);
            }
            if (!(food = handler.getStackInSlot(selectedSlot)).m_41619_() && food.m_41614_() && player.m_36391_(food.getFoodProperties((LivingEntity)player) != null ? food.getFoodProperties((LivingEntity)player).m_38747_() : false)) {
                tag.m_128405_(EAT_SLOT_TAG, selectedSlot);
                tag.m_128379_("IsOpen", true);
                stack.m_41751_(tag);
                player.m_6672_(hand);
                return InteractionResultHolder.m_19096_((Object)stack);
            }
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public static boolean isBattery(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        if (stack.m_204117_(ELECTRIC_BATTERIES)) {
            return true;
        }
        if (GregTechIntegration.isGregTechLoaded()) {
            try {
                boolean hasElectricCapability;
                Class<?> gtCapabilityHelperClass = Class.forName("com.gregtechceu.gtceu.api.capability.GTCapabilityHelper");
                Method getElectricItemMethod = gtCapabilityHelperClass.getMethod("getElectricItem", ItemStack.class);
                Object electricItem = getElectricItemMethod.invoke(null, stack);
                boolean bl = hasElectricCapability = electricItem != null;
                if (hasElectricCapability) {
                    Method getChargeMethod = electricItem.getClass().getMethod("getCharge", new Class[0]);
                    Method getMaxChargeMethod = electricItem.getClass().getMethod("getMaxCharge", new Class[0]);
                    Method canProvideChargeExternallyMethod = electricItem.getClass().getMethod("canProvideChargeExternally", new Class[0]);
                    long charge = (Long)getChargeMethod.invoke(electricItem, new Object[0]);
                    long maxCharge = (Long)getMaxChargeMethod.invoke(electricItem, new Object[0]);
                    boolean bl2 = (Boolean)canProvideChargeExternallyMethod.invoke(electricItem, new Object[0]);
                }
                return hasElectricCapability;
            }
            catch (Exception e) {
                TFCLunchBox.LOGGER.warn("Error checking battery status for {}: {}", (Object)stack.m_41720_().getClass().getSimpleName(), (Object)e.getMessage());
                return false;
            }
        }
        return false;
    }

    public static long getStoredEnergy(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return 0L;
        }
        return tag.m_128454_(ENERGY_TAG);
    }

    public static void setStoredEnergy(ItemStack stack, long energy) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128356_(ENERGY_TAG, Math.max(0L, Math.min(8000L, energy)));
        stack.m_41751_(tag);
    }

    public static boolean consumeEnergy(ItemStack stack, long amount) {
        long stored = ElectricLunchboxItem.getStoredEnergy(stack);
        if (stored >= amount) {
            ElectricLunchboxItem.setStoredEnergy(stack, stored - amount);
            return true;
        }
        return false;
    }

    public static void chargeFromBattery(ItemStack lunchbox, ItemStack battery) {
        if (!ElectricLunchboxItem.isBattery(battery)) {
            return;
        }
        if (!GregTechIntegration.isGregTechLoaded()) {
            return;
        }
        try {
            long currentEnergy = ElectricLunchboxItem.getStoredEnergy(lunchbox);
            long maxTransfer = Math.min(8000L - currentEnergy, 100L);
            if (maxTransfer > 0L) {
                int extracted;
                IEnergyStorage energyStorage;
                Method canProvideChargeExternallyMethod;
                boolean canProvide;
                Class<?> gtCapabilityHelperClass = Class.forName("com.gregtechceu.gtceu.api.capability.GTCapabilityHelper");
                Method getElectricItemMethod = gtCapabilityHelperClass.getMethod("getElectricItem", ItemStack.class);
                Object electricItem = getElectricItemMethod.invoke(null, battery);
                if (electricItem != null && (canProvide = ((Boolean)(canProvideChargeExternallyMethod = electricItem.getClass().getMethod("canProvideChargeExternally", new Class[0])).invoke(electricItem, new Object[0])).booleanValue())) {
                    Method dischargeMethod = electricItem.getClass().getMethod("discharge", Long.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
                    long discharged = (Long)dischargeMethod.invoke(electricItem, maxTransfer, Integer.MAX_VALUE, false, true, false);
                    if (discharged > 0L) {
                        ElectricLunchboxItem.setStoredEnergy(lunchbox, currentEnergy + discharged);
                    }
                    return;
                }
                LazyOptional energyCapability = battery.getCapability(ForgeCapabilities.ENERGY);
                if (energyCapability.isPresent() && (energyStorage = (IEnergyStorage)energyCapability.orElse(null)) != null && energyStorage.canExtract() && (extracted = energyStorage.extractEnergy((int)maxTransfer, false)) > 0) {
                    ElectricLunchboxItem.setStoredEnergy(lunchbox, currentEnergy + (long)extracted);
                }
            }
        }
        catch (Exception e) {
            TFCLunchBox.LOGGER.warn("Error charging from battery {}: {}", (Object)battery.m_41720_().getClass().getSimpleName(), (Object)e.getMessage());
        }
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slot, boolean selected) {
        Player player;
        if (level.f_46443_) {
            return;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return;
        }
        if (tag.m_128471_("IsOpen") && entity instanceof Player) {
            boolean isEating;
            player = (Player)entity;
            boolean isContainerOpen = player.f_36096_ instanceof ElectricLunchboxContainer;
            boolean bl = isEating = player.m_6117_() && player.m_21211_() == stack;
            if (!isContainerOpen && !isEating) {
                tag.m_128379_("IsOpen", false);
                stack.m_41751_(tag);
            }
        }
        if (entity instanceof Player) {
            player = (Player)entity;
            if (player.f_36096_ != null && !player.f_36096_.getClass().getSimpleName().equals("InventoryMenu")) {
                return;
            }
        }
        if (level.m_46467_() % 20L == 0L) {
            this.updateElectricLunchbox(stack, level);
        }
    }

    private void updateElectricLunchbox(ItemStack stack, Level level) {
        long currentEnergy;
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_("Items")) {
            return;
        }
        ItemStackHandler handler = new ItemStackHandler(10);
        handler.deserializeNBT(tag.m_128469_("Items"));
        ItemStack battery = handler.getStackInSlot(9);
        if (!battery.m_41619_() && ElectricLunchboxItem.isBattery(battery)) {
            ElectricLunchboxItem.chargeFromBattery(stack, battery);
        }
        boolean hasFood = false;
        for (int i = 0; i < 9; ++i) {
            ItemStack food = handler.getStackInSlot(i);
            if (food.m_41619_() || !ElectricLunchboxItem.checkItemValid(food)) continue;
            hasFood = true;
            break;
        }
        boolean hasEnergy = (currentEnergy = ElectricLunchboxItem.getStoredEnergy(stack)) >= 1L;
        boolean needsUpdate = false;
        for (int i = 0; i < 9; ++i) {
            ItemStack food = handler.getStackInSlot(i);
            if (food.m_41619_() || !ElectricLunchboxItem.checkItemValid(food)) continue;
            if (hasEnergy) {
                FoodCapability.applyTrait((ItemStack)food, (FoodTrait)ElectricLunchboxItem.getLunchboxCooledTrait());
            } else {
                FoodCapability.removeTrait((ItemStack)food, (FoodTrait)ElectricLunchboxItem.getLunchboxCooledTrait());
            }
            handler.setStackInSlot(i, food);
            needsUpdate = true;
        }
        boolean energyChanged = false;
        if (hasFood && hasEnergy) {
            long oldEnergy = currentEnergy;
            ElectricLunchboxItem.consumeEnergy(stack, 1L);
            boolean bl = energyChanged = ElectricLunchboxItem.getStoredEnergy(stack) != oldEnergy;
        }
        if (needsUpdate || energyChanged) {
            tag.m_128365_("Items", (Tag)handler.serializeNBT());
            stack.m_41751_(tag);
        }
    }

    public static int getEatSlot(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return 0;
        }
        return tag.m_128451_(EAT_SLOT_TAG);
    }

    public static void setEatSlot(ItemStack stack, int slot) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_(EAT_SLOT_TAG, slot);
        stack.m_41751_(tag);
    }

    public static ItemStack getNextFood(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_("Items")) {
            return ItemStack.f_41583_;
        }
        ItemStackHandler handler = new ItemStackHandler(10);
        handler.deserializeNBT(tag.m_128469_("Items"));
        int currentSlot = ElectricLunchboxItem.getEatSlot(stack);
        for (int i = 0; i < 9; ++i) {
            int slotToCheck = (currentSlot + i) % 9;
            ItemStack food = handler.getStackInSlot(slotToCheck);
            if (food.m_41619_() || !ElectricLunchboxItem.checkItemValid(food)) continue;
            ElectricLunchboxItem.setEatSlot(stack, (slotToCheck + 1) % 9);
            ItemStack result = food.m_41777_();
            food.m_41774_(1);
            handler.setStackInSlot(slotToCheck, food);
            tag.m_128365_("Items", (Tag)handler.serializeNBT());
            stack.m_41751_(tag);
            return result;
        }
        return ItemStack.f_41583_;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        ElectricLunchboxCapabilityProvider provider = new ElectricLunchboxCapabilityProvider(stack);
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("SelectedSlot")) {
            tag.m_128405_("SelectedSlot", 0);
        }
        if (!tag.m_128441_("LunchboxType")) {
            tag.m_128359_("LunchboxType", "electric");
        }
        if (!tag.m_128441_("LunchboxUUID")) {
            tag.m_128359_("LunchboxUUID", UUID.randomUUID().toString());
        }
        return provider;
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity entity) {
        int eatSlot;
        if (!(entity instanceof Player)) {
            return stack;
        }
        Player player = (Player)entity;
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("Items") && tag.m_128441_(EAT_SLOT_TAG) && this.handleEating(stack, level, player, eatSlot = tag.m_128451_(EAT_SLOT_TAG))) {
            return stack;
        }
        return stack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag flag) {
        components.add((Component)Component.m_237115_((String)"item.tfclunchbox.electric_lunchbox.main").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC}));
        long energy = ElectricLunchboxItem.getStoredEnergy(stack);
        long maxEnergy = 8000L;
        components.add((Component)Component.m_237110_((String)"tooltip.tfclunchbox.energy", (Object[])new Object[]{energy, maxEnergy}).m_130940_(energy > 0L ? ChatFormatting.GREEN : ChatFormatting.RED));
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("Items")) {
            ItemStackHandler handler = new ItemStackHandler(10);
            handler.deserializeNBT(tag.m_128469_("Items"));
            boolean hasEnergy = energy >= 1L;
            HashMap<String, FoodInfo> foodMap = new HashMap<String, FoodInfo>();
            for (int i = 0; i < 9; ++i) {
                ItemStack food = handler.getStackInSlot(i);
                if (food.m_41619_() || !ElectricLunchboxItem.checkItemValid(food)) continue;
                String name = food.m_41786_().getString();
                boolean isCooled = hasEnergy && FoodCapability.hasTrait((ItemStack)food, (FoodTrait)ElectricLunchboxItem.getLunchboxCooledTrait());
                FoodInfo info = foodMap.getOrDefault(name, new FoodInfo(name, 0, false));
                info.count += food.m_41613_();
                info.isCooled = isCooled;
                foodMap.put(name, info);
            }
            if (foodMap.isEmpty()) {
                components.add((Component)Component.m_237113_((String)"  ").m_7220_((Component)Component.m_237115_((String)"tooltip.tfclunchbox.empty")).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            } else {
                for (FoodInfo info : foodMap.values()) {
                    if (info.isCooled) {
                        MutableComponent foodComponent = Component.m_237113_((String)(" \u2022 " + info.name + " x" + info.count)).m_130940_(ChatFormatting.AQUA);
                        foodComponent = foodComponent.m_7220_((Component)Component.m_237113_((String)" \u2744").m_130940_(ChatFormatting.BLUE));
                        components.add((Component)foodComponent);
                        continue;
                    }
                    components.add((Component)Component.m_237113_((String)(" \u2022 " + info.name + " x" + info.count)).m_130940_(ChatFormatting.WHITE));
                }
                if (hasEnergy) {
                    components.add((Component)Component.m_237115_((String)"tooltip.tfclunchbox.cooling_active").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
                } else {
                    components.add((Component)Component.m_237115_((String)"tooltip.tfclunchbox.cooling_inactive").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
                }
            }
        }
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (oldStack.m_41720_() != newStack.m_41720_() || slotChanged) {
            return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
        }
        ItemStack oldCopy = oldStack.m_41777_();
        ItemStack newCopy = newStack.m_41777_();
        this.removeIgnoredTags(oldCopy.m_41784_(), this.getAdditionalIgnoredTags());
        this.removeIgnoredTags(newCopy.m_41784_(), this.getAdditionalIgnoredTags());
        return !ItemStack.m_41728_((ItemStack)oldCopy, (ItemStack)newCopy);
    }

    @Override
    protected String getEatSlotTag() {
        return EAT_SLOT_TAG;
    }

    @Override
    protected String[] getAdditionalIgnoredTags() {
        return new String[]{ENERGY_TAG, "LunchboxType", "LunchboxUUID"};
    }

    @Override
    protected Class<?>[] getExcludedClasses() {
        return new Class[]{ElectricLunchboxItem.class};
    }

    private static class FoodInfo {
        String name;
        int count;
        boolean isCooled;

        FoodInfo(String name, int count, boolean isCooled) {
            this.name = name;
            this.count = count;
            this.isCooled = isCooled;
        }
    }
}

