/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.tfclunchbox.item;

import dev.thomas.tfclunchbox.item.SimpleLunchboxItem;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleLunchboxCapabilityProvider
implements ICapabilityProvider {
    private final ItemStack lunchbox;
    private final ItemStackHandler itemHandler;
    private final LazyOptional<ItemStackHandler> lazyHandler;

    public SimpleLunchboxCapabilityProvider(final ItemStack lunchbox) {
        this.lunchbox = lunchbox;
        this.itemHandler = new ItemStackHandler(9){

            protected void onContentsChanged(int slot) {
                CompoundTag containerTag = lunchbox.m_41784_();
                containerTag.m_128365_("Items", (Tag)this.serializeNBT());
                lunchbox.m_41751_(containerTag);
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return SimpleLunchboxItem.checkItemValid(stack);
            }
        };
        this.lazyHandler = LazyOptional.of(() -> this.itemHandler);
        this.loadNBT();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyHandler.cast();
        }
        return LazyOptional.empty();
    }

    public void loadNBT() {
        CompoundTag tag = this.lunchbox.m_41784_();
        if (tag.m_128441_("Items")) {
            this.itemHandler.deserializeNBT(tag.m_128469_("Items"));
        }
    }

    public void loadNBT(CompoundTag nbt) {
        if (nbt.m_128441_("Items")) {
            this.itemHandler.deserializeNBT(nbt.m_128469_("Items"));
        }
    }

    private void saveNBT() {
        CompoundTag tag = this.lunchbox.m_41784_();
        tag.m_128365_("Items", (Tag)this.itemHandler.serializeNBT());
        this.lunchbox.m_41751_(tag);
    }
}

