/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.tfclunchbox.item;

import dev.thomas.tfclunchbox.container.SimpleLunchboxContainer;
import dev.thomas.tfclunchbox.item.BaseLunchboxItem;
import dev.thomas.tfclunchbox.item.CoolingLunchboxItem;
import dev.thomas.tfclunchbox.item.SimpleLunchboxCapabilityProvider;
import dev.thomas.tfclunchbox.util.ClientUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodTrait;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleLunchboxItem
extends BaseLunchboxItem {
    private static final String EAT_SLOT_TAG = "SimpleLunchboxEatSlot";
    public static final FoodTrait LUNCHBOX_PRESERVED = FoodTrait.register((ResourceLocation)new ResourceLocation("tfclunchbox", "lunchbox_preserved"), (FoodTrait)new FoodTrait(0.45f, "tooltip.tfclunchbox.food_trait.lunchbox_preserved"));

    public static FoodTrait getLunchboxPreservedTrait() {
        return LUNCHBOX_PRESERVED;
    }

    public static boolean checkItemValid(ItemStack stack) {
        return BaseLunchboxItem.checkItemValid(stack, SimpleLunchboxItem.class, CoolingLunchboxItem.class);
    }

    public SimpleLunchboxItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            if (!level.m_5776_()) {
                stack.m_41784_().m_128379_("IsOpen", true);
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((windowId, playerInventory, _player) -> new SimpleLunchboxContainer(windowId, playerInventory, stack, hand), (Component)Component.m_237115_((String)"container.tfclunchbox.lunchbox").m_130940_(ChatFormatting.GOLD)), buf -> {
                    buf.m_130055_(stack);
                    buf.m_130068_((Enum)hand);
                    int encodedSlot = hand == InteractionHand.OFF_HAND ? -1 : player.m_150109_().f_35977_;
                    buf.writeByte(encodedSlot);
                });
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("Items")) {
            ItemStack food;
            int selectedSlot;
            ItemStackHandler handler = new ItemStackHandler(9);
            handler.deserializeNBT(tag.m_128469_("Items"));
            int n = selectedSlot = tag.m_128441_("SelectedSlot") ? tag.m_128451_("SelectedSlot") : 0;
            if (selectedSlot < 0 || selectedSlot >= 9) {
                selectedSlot = 0;
                tag.m_128405_("SelectedSlot", selectedSlot);
            }
            if (!(food = handler.getStackInSlot(selectedSlot)).m_41619_() && food.m_41614_() && player.m_36391_(food.getFoodProperties((LivingEntity)player) != null ? food.getFoodProperties((LivingEntity)player).m_38747_() : false)) {
                tag.m_128405_(EAT_SLOT_TAG, selectedSlot);
                tag.m_128379_("IsOpen", true);
                stack.m_41751_(tag);
                player.m_6672_(hand);
                return InteractionResultHolder.m_19096_((Object)stack);
            }
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity entity) {
        int eatSlot;
        if (!(entity instanceof Player)) {
            return stack;
        }
        Player player = (Player)entity;
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("Items") && tag.m_128441_(EAT_SLOT_TAG) && this.handleEating(stack, level, player, eatSlot = tag.m_128451_(EAT_SLOT_TAG))) {
            return stack;
        }
        return stack;
    }

    public void m_6883_(@NotNull ItemStack stack, Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        CompoundTag tag;
        if (!level.m_5776_() && entity instanceof Player && (tag = stack.m_41784_()).m_128441_("Items")) {
            ItemStackHandler handler = new ItemStackHandler(9);
            handler.deserializeNBT(tag.m_128469_("Items"));
            boolean needsUpdate = false;
            for (int i = 0; i < 9; ++i) {
                ItemStack food = handler.getStackInSlot(i);
                if (food.m_41619_() || !SimpleLunchboxItem.checkItemValid(food)) continue;
                FoodCapability.applyTrait((ItemStack)food, (FoodTrait)SimpleLunchboxItem.getLunchboxPreservedTrait());
                handler.setStackInSlot(i, food);
                needsUpdate = true;
            }
            if (needsUpdate) {
                tag.m_128365_("Items", (Tag)handler.serializeNBT());
                stack.m_41751_(tag);
            }
        }
    }

    @javax.annotation.Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @javax.annotation.Nullable CompoundTag nbt) {
        SimpleLunchboxCapabilityProvider provider = new SimpleLunchboxCapabilityProvider(stack);
        if (nbt != null && nbt.m_128441_("Items")) {
            provider.loadNBT(nbt);
        } else {
            CompoundTag tag = stack.m_41784_();
            if (!tag.m_128441_("SelectedSlot")) {
                tag.m_128405_("SelectedSlot", 0);
            }
        }
        return provider;
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (oldStack.m_41720_() != newStack.m_41720_() || slotChanged) {
            return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
        }
        ItemStack oldCopy = oldStack.m_41777_();
        ItemStack newCopy = newStack.m_41777_();
        this.removeIgnoredTags(oldCopy.m_41784_(), this.getAdditionalIgnoredTags());
        this.removeIgnoredTags(newCopy.m_41784_(), this.getAdditionalIgnoredTags());
        return !ItemStack.m_41728_((ItemStack)oldCopy, (ItemStack)newCopy);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag flag) {
        components.add((Component)Component.m_237115_((String)"item.tfclunchbox.simple_lunchbox.main").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC}));
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("Items")) {
            ItemStackHandler handler = new ItemStackHandler(9);
            handler.deserializeNBT(tag.m_128469_("Items"));
            components.add((Component)Component.m_237115_((String)"tooltip.tfclunchbox.contents"));
            LinkedHashMap<String, Integer> foodMap = new LinkedHashMap<String, Integer>();
            for (int i = 0; i < 9; ++i) {
                ItemStack food = handler.getStackInSlot(i);
                if (food.m_41619_() || !food.m_41614_()) continue;
                String name = food.m_41786_().getString();
                foodMap.put(name, foodMap.getOrDefault(name, 0) + food.m_41613_());
            }
            for (Map.Entry entry : foodMap.entrySet()) {
                components.add((Component)Component.m_237113_((String)(" \u2022 " + (String)entry.getKey() + " x" + String.valueOf(entry.getValue()))));
            }
        }
        if (ClientUtils.isShiftDown()) {
            components.add((Component)Component.m_237115_((String)"tooltip.tfclunchbox.simple_lunchbox.shift_info").m_130940_(ChatFormatting.GRAY));
        } else {
            components.add((Component)Component.m_237115_((String)"tooltip.tfclunchbox.simple_lunchbox.hold_shift").m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    @Override
    protected String getEatSlotTag() {
        return EAT_SLOT_TAG;
    }

    @Override
    protected String[] getAdditionalIgnoredTags() {
        return new String[0];
    }

    @Override
    protected Class<?>[] getExcludedClasses() {
        return new Class[]{SimpleLunchboxItem.class, CoolingLunchboxItem.class};
    }
}

