/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.tfclunchbox.item;

import dev.thomas.tfclunchbox.item.ModItems;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.NotNull;

public class UniversalCapsuleItem
extends Item {
    public static final int MAX_DURABILITY = 1000;

    public UniversalCapsuleItem(Item.Properties properties) {
        super(properties);
    }

    public boolean isDamageable(ItemStack stack) {
        return true;
    }

    public int getMaxDamage(ItemStack stack) {
        return 1000;
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return UniversalCapsuleItem.getDurability(stack) > 0;
    }

    public int m_142158_(@NotNull ItemStack stack) {
        return Math.round((float)UniversalCapsuleItem.getDurability(stack) * 13.0f / 1000.0f);
    }

    public static int getDurability(ItemStack stack) {
        return stack.m_41784_().m_128451_("Durability");
    }

    public void m_7836_(ItemStack stack, @NotNull Level level, @NotNull Player player) {
        CompoundTag nbt = stack.m_41784_();
        if (!nbt.m_128441_("Durability")) {
            nbt.m_128405_("Durability", 0);
        }
        super.m_7836_(stack, level, player);
    }

    public boolean isRepairable(@NotNull ItemStack stack) {
        return false;
    }

    public static void onCapsuleUse(PlayerInteractEvent.RightClickItem event) {
        int currentDurability;
        ItemStack stack = event.getItemStack();
        if (stack.m_41720_() == ModItems.UNIVERSAL_CAPSULE.get() && event.getLevel().m_8055_(event.getPos()).m_60734_() == Blocks.f_50126_ && (currentDurability = UniversalCapsuleItem.getDurability(stack)) < 1000) {
            stack.m_41784_().m_128405_("Durability", Math.min(currentDurability + 10, 1000));
            stack.m_41714_((Component)Component.m_237115_((String)"item.tfclunchbox.universal_capsule.filled"));
            event.getEntity().m_6674_(event.getHand());
        }
    }

    public static void setDurability(ItemStack stack, int durability) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("Durability", Math.max(0, Math.min(durability, 1000)));
        stack.m_41751_(tag);
    }

    public void m_7373_(@NotNull ItemStack stack, Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        int durability = UniversalCapsuleItem.getDurability(stack);
        if (durability > 0) {
            tooltip.add((Component)Component.m_237115_((String)"item.tfclunchbox.universal_capsule.filled.tooltip"));
            tooltip.add((Component)Component.m_237110_((String)"item.tfclunchbox.universal_capsule.ice_remaining", (Object[])new Object[]{durability, 1000}).m_130940_(ChatFormatting.AQUA));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"item.tfclunchbox.universal_capsule.tooltip"));
        }
    }
}

