/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.tfclunchbox.network;

import dev.thomas.tfclunchbox.item.CoolingLunchboxItem;
import dev.thomas.tfclunchbox.item.ElectricLunchboxItem;
import dev.thomas.tfclunchbox.item.SimpleLunchboxItem;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class SelectSlotPacket {
    private final int slot;

    public SelectSlotPacket(int slot) {
        this.slot = slot;
    }

    public static void encode(SelectSlotPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.slot);
    }

    public static SelectSlotPacket decode(FriendlyByteBuf buffer) {
        return new SelectSlotPacket(buffer.readInt());
    }

    public static void handle(SelectSlotPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null || !player.m_6084_()) {
                return;
            }
            if (packet.slot < 0) {
                return;
            }
            InteractionHand hand = null;
            ItemStack mainHand = player.m_21205_();
            ItemStack offHand = player.m_21206_();
            int maxSlots = 0;
            if (mainHand.m_41720_() instanceof CoolingLunchboxItem) {
                hand = InteractionHand.MAIN_HAND;
                maxSlots = 9;
            } else if (offHand.m_41720_() instanceof CoolingLunchboxItem) {
                hand = InteractionHand.OFF_HAND;
                maxSlots = 9;
            } else if (mainHand.m_41720_() instanceof SimpleLunchboxItem) {
                hand = InteractionHand.MAIN_HAND;
                maxSlots = 9;
            } else if (offHand.m_41720_() instanceof SimpleLunchboxItem) {
                hand = InteractionHand.OFF_HAND;
                maxSlots = 9;
            } else if (mainHand.m_41720_() instanceof ElectricLunchboxItem) {
                hand = InteractionHand.MAIN_HAND;
                maxSlots = 9;
            } else if (offHand.m_41720_() instanceof ElectricLunchboxItem) {
                hand = InteractionHand.OFF_HAND;
                maxSlots = 9;
            }
            if (hand != null && maxSlots > 0) {
                ItemStack heldItem = player.m_21120_(hand);
                CompoundTag tag = heldItem.m_41784_();
                int newSlot = Math.max(0, Math.min(packet.slot, maxSlots - 1));
                tag.m_128405_("SelectedSlot", newSlot);
                heldItem.m_41751_(tag);
                player.m_21008_(hand, heldItem);
            }
        });
        context.setPacketHandled(true);
    }
}

