/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.tfclunchbox.recipe;

import com.google.gson.JsonObject;
import dev.thomas.tfclunchbox.item.ModItems;
import dev.thomas.tfclunchbox.item.UniversalCapsuleItem;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class FillCapsuleRecipe
extends CustomRecipe {
    public static final RecipeSerializer<FillCapsuleRecipe> SERIALIZER = new RecipeSerializer<FillCapsuleRecipe>(){

        @NotNull
        public FillCapsuleRecipe fromJson(@NotNull ResourceLocation id, @NotNull JsonObject json) {
            return new FillCapsuleRecipe(id);
        }

        public FillCapsuleRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buffer) {
            return new FillCapsuleRecipe(id);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull FillCapsuleRecipe recipe) {
        }
    };

    public FillCapsuleRecipe(ResourceLocation id) {
        super(id, CraftingBookCategory.MISC);
    }

    public boolean matches(CraftingContainer container, @NotNull Level level) {
        int possibleIncrease;
        boolean hasCapsule = false;
        int iceCount = 0;
        ItemStack capsuleStack = ItemStack.f_41583_;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() == ModItems.UNIVERSAL_CAPSULE.get()) {
                if (hasCapsule) {
                    return false;
                }
                hasCapsule = true;
                capsuleStack = stack;
                continue;
            }
            if (stack.m_41720_() == Items.f_41980_) {
                iceCount += stack.m_41613_();
                continue;
            }
            return false;
        }
        if (!hasCapsule || iceCount <= 0) {
            return false;
        }
        int currentDurability = UniversalCapsuleItem.getDurability(capsuleStack);
        return currentDurability + (possibleIncrease = iceCount * 10) <= 1000;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer container, @NotNull RegistryAccess registryAccess) {
        ItemStack capsule = this.findCapsule(container);
        if (capsule.m_41619_()) {
            return ItemStack.f_41583_;
        }
        int currentDurability = UniversalCapsuleItem.getDurability(capsule);
        int iceSlots = this.countIceSlots(container);
        int required = (int)Math.ceil((double)(1000 - currentDurability) / 10.0);
        int used = Math.min(iceSlots, required);
        ItemStack result = capsule.m_41777_();
        UniversalCapsuleItem.setDurability(result, currentDurability + used * 10);
        if (UniversalCapsuleItem.getDurability(result) > 0) {
            result.m_41714_((Component)Component.m_237115_((String)"item.tfclunchbox.universal_capsule.filled"));
        }
        return result;
    }

    private ItemStack findCapsule(CraftingContainer container) {
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41720_() != ModItems.UNIVERSAL_CAPSULE.get()) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    private int countIceSlots(CraftingContainer container) {
        int count = 0;
        for (int i = 0; i < container.m_6643_(); ++i) {
            if (container.m_8020_(i).m_41720_() != Items.f_41980_) continue;
            ++count;
        }
        return count;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }
}

