/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.essentiax.core;

import de.scholle.essentiax.EssentiaX;
import de.scholle.essentiax.core.ConfigHelper;
import de.scholle.essentiax.core.Language;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Home
implements CommandExecutor {
    private final EssentiaX plugin;
    private final Language lang;
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();

    public Home(EssentiaX plugin, Language lang) {
        this.plugin = plugin;
        this.lang = lang;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        HashMap<String, String> placeholders;
        Location initial;
        HashMap<String, String> placeholders2;
        long remaining;
        String name;
        if (!(sender instanceof Player)) {
            return true;
        }
        final Player player = (Player)sender;
        if (!ConfigHelper.getSafeBoolean((Configuration)this.plugin.getConfig(), "home.enabled", true)) {
            return true;
        }
        if (args.length == 0) {
            name = "";
        } else if (args.length == 1) {
            name = args[0].toLowerCase();
        } else {
            return true;
        }
        final int standTime = ConfigHelper.getSafeInt((Configuration)this.plugin.getConfig(), "home.stand-still-time", 5);
        int cooldown = ConfigHelper.getSafeInt((Configuration)this.plugin.getConfig(), "home.cooldown", 0);
        int maxHomes = ConfigHelper.getSafeInt((Configuration)this.plugin.getConfig(), "home.max-homes", 3);
        long now = System.currentTimeMillis();
        if (this.cooldowns.containsKey(player.getUniqueId()) && (remaining = (this.cooldowns.get(player.getUniqueId()) + (long)cooldown * 1000L - now) / 1000L) > 0L) {
            HashMap<String, String> placeholders3 = new HashMap<String, String>();
            placeholders3.put("seconds", String.valueOf(remaining));
            player.sendMessage(this.lang.get("home.wait", placeholders3));
            return true;
        }
        final HashMap<String, Location> homes = new HashMap<String, Location>();
        if (this.plugin.getConfig().getConfigurationSection("homes." + player.getUniqueId()) != null) {
            for (String key : this.plugin.getConfig().getConfigurationSection("homes." + player.getUniqueId()).getKeys(false)) {
                String path = "homes." + player.getUniqueId() + "." + key + ".";
                String worldName = this.plugin.getConfig().getString(path + "world");
                if (worldName == null) continue;
                double x = this.plugin.getConfig().getDouble(path + "x");
                double y = this.plugin.getConfig().getDouble(path + "y");
                double z = this.plugin.getConfig().getDouble(path + "z");
                float yaw = (float)this.plugin.getConfig().getDouble(path + "yaw");
                float pitch = (float)this.plugin.getConfig().getDouble(path + "pitch");
                Location loc = new Location(Bukkit.getWorld((String)worldName), x, y, z, yaw, pitch);
                homes.put(key, loc);
            }
        }
        if (command.getName().equalsIgnoreCase("sethome")) {
            if (homes.size() >= maxHomes && !homes.containsKey(name)) {
                placeholders2 = new HashMap<String, String>();
                placeholders2.put("max", String.valueOf(maxHomes));
                player.sendMessage(this.lang.get("home.max", placeholders2));
                return true;
            }
            if (homes.containsKey(name)) {
                placeholders2 = new HashMap();
                placeholders2.put("home", name.isEmpty() ? "default" : name);
                player.sendMessage(this.lang.get("home.already_exists", placeholders2));
                return true;
            }
            initial = player.getLocation();
            placeholders = new HashMap<String, String>();
            placeholders.put("seconds", String.valueOf(standTime));
            placeholders.put("home", name.isEmpty() ? "default" : name);
            player.sendMessage(this.lang.get("home.stand_set", placeholders));
            new BukkitRunnable(){
                int seconds;
                {
                    this.seconds = standTime;
                }

                public void run() {
                    if (!player.isOnline() || !player.getLocation().getBlock().getLocation().equals((Object)initial.getBlock().getLocation())) {
                        player.sendMessage(Home.this.lang.get("home.canceled_set"));
                        this.cancel();
                        return;
                    }
                    if (this.seconds <= 0) {
                        Location loc = player.getLocation();
                        homes.put(name, loc);
                        String path = "homes." + player.getUniqueId() + "." + name + ".";
                        Home.this.plugin.getConfig().set(path + "world", (Object)loc.getWorld().getName());
                        Home.this.plugin.getConfig().set(path + "x", (Object)loc.getX());
                        Home.this.plugin.getConfig().set(path + "y", (Object)loc.getY());
                        Home.this.plugin.getConfig().set(path + "z", (Object)loc.getZ());
                        Home.this.plugin.getConfig().set(path + "yaw", (Object)Float.valueOf(loc.getYaw()));
                        Home.this.plugin.getConfig().set(path + "pitch", (Object)Float.valueOf(loc.getPitch()));
                        Home.this.plugin.saveConfig();
                        HashMap<String, String> placeholders = new HashMap<String, String>();
                        placeholders.put("home", name.isEmpty() ? "default" : name);
                        player.sendMessage(Home.this.lang.get("home.set", placeholders));
                        Home.this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis());
                        this.cancel();
                    }
                    --this.seconds;
                }
            }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
        } else if (command.getName().equalsIgnoreCase("home")) {
            if (!homes.containsKey(name)) {
                placeholders2 = new HashMap();
                placeholders2.put("home", name.isEmpty() ? "default" : name);
                player.sendMessage(this.lang.get("home.missing", placeholders2));
                return true;
            }
            initial = player.getLocation();
            placeholders = new HashMap();
            placeholders.put("seconds", String.valueOf(standTime));
            placeholders.put("home", name.isEmpty() ? "default" : name);
            player.sendMessage(this.lang.get("home.stand_tp", placeholders));
            new BukkitRunnable(){
                int seconds;
                {
                    this.seconds = standTime;
                }

                public void run() {
                    if (!player.isOnline() || !player.getLocation().getBlock().getLocation().equals((Object)initial.getBlock().getLocation())) {
                        player.sendMessage(Home.this.lang.get("home.canceled"));
                        this.cancel();
                        return;
                    }
                    if (this.seconds <= 0) {
                        player.teleport((Location)homes.get(name));
                        HashMap<String, String> placeholders = new HashMap<String, String>();
                        placeholders.put("home", name.isEmpty() ? "default" : name);
                        player.sendMessage(Home.this.lang.get("home.tp", placeholders));
                        Home.this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis());
                        this.cancel();
                    }
                    --this.seconds;
                }
            }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
        }
        return true;
    }
}

