/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.essentiax.core;

import de.scholle.essentiax.EssentiaX;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;

public class RTP
implements CommandExecutor,
Listener {
    private final EssentiaX plugin;
    private final Random random = new Random();
    private final Set<Player> teleportingPlayers = new HashSet<Player>();

    public RTP(EssentiaX plugin) {
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can execute this command.");
            return true;
        }
        Player player = (Player)sender;
        if (!this.plugin.getConfig().getBoolean("rtp.enabled", true)) {
            player.sendMessage("Random teleport is currently disabled.");
            return true;
        }
        int minX = this.plugin.getConfig().getInt("rtp.min-x", -1000);
        int maxX = this.plugin.getConfig().getInt("rtp.max-x", 1000);
        int minZ = this.plugin.getConfig().getInt("rtp.min-z", -1000);
        int maxZ = this.plugin.getConfig().getInt("rtp.max-z", 1000);
        int waitTimeSeconds = this.plugin.getConfig().getInt("rtp.wait-seconds", 5);
        World world = player.getWorld();
        int x = this.random.nextInt(maxX - minX + 1) + minX;
        int z = this.random.nextInt(maxZ - minZ + 1) + minZ;
        int y = world.getHighestBlockYAt(x, z);
        Location randomLocation = new Location(world, (double)x + 0.5, (double)(y + 1), (double)z + 0.5);
        player.sendMessage("Teleports in " + waitTimeSeconds + " seconds. Please stand still!");
        this.teleportingPlayers.add(player);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (this.teleportingPlayers.contains(player)) {
                player.teleport(randomLocation);
                player.sendMessage("You have been teleported randomly!");
                this.teleportingPlayers.remove(player);
            }
        }, (long)waitTimeSeconds * 20L);
        return true;
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (this.teleportingPlayers.contains(player) && event.getFrom().distanceSquared(event.getTo()) > 0.0) {
            event.setCancelled(true);
            player.sendMessage("You must stand still to teleport!");
        }
    }
}

