/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.essentiax.core;

import de.scholle.essentiax.core.Language;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Vanish
implements CommandExecutor,
Listener {
    private final JavaPlugin plugin;
    private final FileConfiguration config;
    private final Language lang;
    private final Set<Player> vanishedPlayers = new HashSet<Player>();
    private final Set<Player> invisiblePlayers = new HashSet<Player>();

    public Vanish(JavaPlugin plugin, Language lang) {
        this.plugin = plugin;
        this.config = plugin.getConfig();
        this.lang = lang;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return true;
        }
        Player player = (Player)sender;
        if (!player.isOp()) {
            player.sendMessage(ChatColor.RED + "You do not have permission to use this command!");
            return true;
        }
        if (this.vanishedPlayers.contains(player)) {
            this.unvanish(player);
            player.sendMessage(ChatColor.GREEN + "You have left vanish mode.");
        } else {
            this.vanish(player);
            player.sendMessage(ChatColor.GREEN + "You entered vanish mode.");
        }
        return true;
    }

    private void vanish(Player player) {
        this.saveInventory(player);
        player.getInventory().clear();
        ItemStack lime = new ItemStack(Material.GREEN_GLAZED_TERRACOTTA);
        ItemMeta limeMeta = lime.getItemMeta();
        limeMeta.setDisplayName(ChatColor.GREEN + "Visibility: Invisible");
        lime.setItemMeta(limeMeta);
        player.getInventory().setItem(0, lime);
        ItemStack barrier = new ItemStack(Material.BARRIER);
        ItemMeta barrierMeta = barrier.getItemMeta();
        barrierMeta.setDisplayName(ChatColor.RED + "Leave Vanish");
        barrier.setItemMeta(barrierMeta);
        player.getInventory().setItem(8, barrier);
        this.vanishedPlayers.add(player);
        this.invisiblePlayers.add(player);
        for (Player online : Bukkit.getOnlinePlayers()) {
            if (online.equals(player)) continue;
            online.hidePlayer((Plugin)this.plugin, player);
        }
        player.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 1, false, false));
        player.setAllowFlight(true);
        player.setFlying(true);
        player.setCollidable(false);
        player.setPlayerListName("");
        String message = this.lang.get("vanish.left", Collections.singletonMap("player", player.getName()));
        Bukkit.broadcastMessage((String)message);
    }

    private void unvanish(Player player) {
        this.vanishedPlayers.remove(player);
        this.invisiblePlayers.remove(player);
        this.restoreInventory(player);
        File file = new File(this.plugin.getDataFolder(), "vanish/" + player.getName() + ".yml");
        if (file.exists()) {
            file.delete();
        }
        for (Player online : Bukkit.getOnlinePlayers()) {
            online.showPlayer((Plugin)this.plugin, player);
        }
        player.removePotionEffect(PotionEffectType.INVISIBILITY);
        player.setAllowFlight(false);
        player.setFlying(false);
        player.setCollidable(true);
        player.setPlayerListName(player.getName());
        String message = this.lang.get("vanish.join", Collections.singletonMap("player", player.getName()));
        Bukkit.broadcastMessage((String)message);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player joining = event.getPlayer();
        for (Player vanished : this.invisiblePlayers) {
            joining.hidePlayer((Plugin)this.plugin, vanished);
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item == null) {
            return;
        }
        if (!this.vanishedPlayers.contains(player)) {
            return;
        }
        if (item.getType() == Material.GREEN_GLAZED_TERRACOTTA) {
            event.setCancelled(true);
            for (Player online : Bukkit.getOnlinePlayers()) {
                online.showPlayer((Plugin)this.plugin, player);
            }
            player.removePotionEffect(PotionEffectType.INVISIBILITY);
            this.invisiblePlayers.remove(player);
            ItemStack gray = new ItemStack(Material.GRAY_GLAZED_TERRACOTTA);
            ItemMeta meta = gray.getItemMeta();
            meta.setDisplayName(ChatColor.GRAY + "Visibility: Visible");
            gray.setItemMeta(meta);
            player.getInventory().setItem(0, gray);
        } else if (item.getType() == Material.GRAY_GLAZED_TERRACOTTA) {
            event.setCancelled(true);
            for (Player online : Bukkit.getOnlinePlayers()) {
                if (online.equals(player)) continue;
                online.hidePlayer((Plugin)this.plugin, player);
            }
            player.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 1, false, false));
            this.invisiblePlayers.add(player);
            ItemStack lime = new ItemStack(Material.GREEN_GLAZED_TERRACOTTA);
            ItemMeta meta = lime.getItemMeta();
            meta.setDisplayName(ChatColor.GREEN + "Visibility: Invisible");
            lime.setItemMeta(meta);
            player.getInventory().setItem(0, lime);
        } else if (item.getType() == Material.BARRIER) {
            event.setCancelled(true);
            this.unvanish(player);
            player.sendMessage(ChatColor.GREEN + "You have left vanish mode.");
        }
    }

    private void saveInventory(Player player) {
        File dir = new File(this.plugin.getDataFolder(), "vanish");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File file = new File(dir, player.getName() + ".yml");
        YamlConfiguration yml = new YamlConfiguration();
        ItemStack[] contents = player.getInventory().getContents();
        for (int i = 0; i < contents.length; ++i) {
            yml.set("inventory.slot" + i, (Object)contents[i]);
        }
        try {
            yml.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void restoreInventory(Player player) {
        File file = new File(this.plugin.getDataFolder(), "vanish/" + player.getName() + ".yml");
        if (!file.exists()) {
            return;
        }
        YamlConfiguration yml = YamlConfiguration.loadConfiguration((File)file);
        ItemStack[] contents = new ItemStack[player.getInventory().getSize()];
        for (int i = 0; i < contents.length; ++i) {
            contents[i] = yml.getItemStack("inventory.slot" + i);
        }
        player.getInventory().setContents(contents);
    }
}

