/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.shaded.mobchip.abstraction.ChipUtil;
import be.isach.ultracosmetics.util.Problem;
import be.isach.ultracosmetics.util.SmartLogger;
import be.isach.ultracosmetics.version.ServerVersion;
import be.isach.ultracosmetics.version.VersionManager;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;
import org.bukkit.UnsafeValues;

public class UltraCosmeticsData {
    private static UltraCosmeticsData instance;
    private boolean customCommandBackArrow;
    private String customBackMenuCommand;
    private boolean ammoEnabled;
    private boolean fileStorage = true;
    private boolean treasureChests;
    private boolean moneyTreasureLoot;
    private boolean cooldownInBar;
    private boolean closeAfterSelect;
    private boolean placeHolderColor;
    private String language;
    private boolean ammoPurchase;
    private String useNMS;
    private ServerVersion serverVersion;
    private VersionManager versionManager;
    private final boolean mobchipAvailable = this.checkMobChipAvailable();
    private final UltraCosmetics ultraCosmetics;
    private boolean cosmeticsProfilesEnabled;
    private boolean cosmeticsAffectEntities;

    public UltraCosmeticsData(UltraCosmetics ultraCosmetics) {
        this.ultraCosmetics = ultraCosmetics;
    }

    public static UltraCosmeticsData get() {
        return instance;
    }

    public static void init(UltraCosmetics ultraCosmetics) {
        instance = new UltraCosmeticsData(ultraCosmetics);
    }

    protected void checkTreasureChests() {
        this.moneyTreasureLoot = this.ultraCosmetics.getEconomyHandler().isUsingEconomy() && SettingsManager.getConfig().getBoolean("TreasureChests.Loots.Money.Enabled");
        this.treasureChests = SettingsManager.getConfig().getBoolean("TreasureChests.Enabled");
    }

    protected boolean initModule() {
        SmartLogger logger = this.ultraCosmetics.getSmartLogger();
        logger.write("Initializing module " + String.valueOf((Object)this.serverVersion) + " (expected version: " + this.serverVersion.getName() + ")");
        boolean isNmsDowngrade = false;
        if (this.useNMS.equalsIgnoreCase("force") && this.serverVersion == ServerVersion.NEW) {
            isNmsDowngrade = true;
            this.serverVersion = ServerVersion.latest();
        }
        if (this.useNMS.equalsIgnoreCase("no")) {
            logger.write("NMS support has been disabled in the config, will run without it.");
        } else if (isNmsDowngrade || this.serverVersion.isNmsSupported() && ServerVersion.getMinecraftVersion().equals(this.serverVersion.getName())) {
            if (this.startNMS()) {
                return true;
            }
        } else {
            logger.write("Loading NMS-less mode...");
        }
        try {
            this.versionManager = new VersionManager(this.serverVersion, false);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
            logger.write(SmartLogger.LogLevel.ERROR, "Failed to start NMS-less module, please report this error.");
            return false;
        }
        logger.write("Loaded NMS-less mode");
        return true;
    }

    protected boolean startNMS() {
        SmartLogger logger = this.ultraCosmetics.getSmartLogger();
        if (!this.checkMappingsVersion(this.serverVersion)) {
            this.ultraCosmetics.addProblem(Problem.BAD_MAPPINGS_VERSION);
            if (this.useNMS.equalsIgnoreCase("force")) {
                logger.write(SmartLogger.LogLevel.WARNING, "Server internals seem to have changed since this build was created,");
                logger.write(SmartLogger.LogLevel.WARNING, "but you have chosen to override version checking!");
            } else {
                logger.write(SmartLogger.LogLevel.WARNING, "Server internals have changed since this build was created, so");
                logger.write(SmartLogger.LogLevel.WARNING, "NMS support will be disabled. If you're sure you know what you're doing,");
                logger.write(SmartLogger.LogLevel.WARNING, "you can override this in the config.");
                return false;
            }
        }
        try {
            this.versionManager = new VersionManager(this.serverVersion, true);
        }
        catch (NoClassDefFoundError | ReflectiveOperationException e) {
            if (e instanceof NoClassDefFoundError) {
                StackTraceElement[] elements = ((NoClassDefFoundError)e).getStackTrace();
                for (int i = 0; i < 5; ++i) {
                    if (!elements[i].getClassName().startsWith("io.papermc.reflectionrewriter")) continue;
                    String brand = Bukkit.getName();
                    logger.write(SmartLogger.LogLevel.WARNING, "This appears to be a version of " + brand + " that doesn't support remapping.");
                    logger.write(SmartLogger.LogLevel.WARNING, "Please check for " + brand + " updates. UC will try to continue in NMS-less mode.");
                    this.ultraCosmetics.addProblem(Problem.NMS_LOAD_FAILURE);
                    return false;
                }
            }
            e.printStackTrace();
            logger.write(SmartLogger.LogLevel.ERROR, "Couldn't find module for " + String.valueOf((Object)this.serverVersion) + ", please report this issue.");
            logger.write("UC will try to continue in NMS-less mode.");
            this.ultraCosmetics.addProblem(Problem.NMS_LOAD_FAILURE);
            return false;
        }
        if (!this.versionManager.getModule().enable()) {
            logger.write(SmartLogger.LogLevel.ERROR, "Failed to start NMS module, please report this issue.");
            logger.write("UC will try to continue in NMS-less mode.");
            this.ultraCosmetics.addProblem(Problem.NMS_LOAD_FAILURE);
            return false;
        }
        logger.write("Loaded NMS support");
        return true;
    }

    protected Problem checkServerVersion() {
        ServerVersion serverVersion;
        String version = ServerVersion.getMinecraftVersion();
        String[] parts = version.split("\\.");
        int majorVer = Integer.parseInt(parts[1]);
        int minorVer = 0;
        if (parts.length > 2) {
            minorVer = Integer.parseInt(parts[2]);
        }
        if ((serverVersion = ServerVersion.byId(majorVer)) == null || serverVersion.getNMSRevision() > 0 && serverVersion.getMinorVer() < minorVer) {
            this.serverVersion = ServerVersion.NEW;
            return Problem.BAD_MC_VERSION;
        }
        this.serverVersion = serverVersion;
        return null;
    }

    protected boolean checkMappingsVersion(ServerVersion version) {
        String currentMappingsVersion;
        if (version.getMappingsVersion() == null) {
            return true;
        }
        UnsafeValues magicNumbers = Bukkit.getUnsafe();
        Class<?> magicNumbersClass = magicNumbers.getClass();
        try {
            Method mappingsVersionMethod = magicNumbersClass.getDeclaredMethod("getMappingsVersion", new Class[0]);
            currentMappingsVersion = (String)mappingsVersionMethod.invoke((Object)magicNumbers, new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            return true;
        }
        return currentMappingsVersion.equals(version.getMappingsVersion());
    }

    public boolean isMobChipAvailable() {
        return this.mobchipAvailable;
    }

    private boolean checkMobChipAvailable() {
        if (ServerVersion.isMobchipEdgeCase()) {
            return false;
        }
        try {
            ChipUtil.getWrapper();
            return true;
        }
        catch (IllegalStateException | NoClassDefFoundError e) {
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void initConfigFields() {
        this.fileStorage = !SettingsManager.getConfig().getBoolean("MySQL.Enabled");
        this.placeHolderColor = SettingsManager.getConfig().getBoolean("Chat-Cosmetic-PlaceHolder-Color");
        this.ammoEnabled = SettingsManager.getConfig().getBoolean("Ammo-System-For-Gadgets.Enabled");
        this.cooldownInBar = SettingsManager.getConfig().getBoolean("Categories.Gadgets.Cooldown-In-ActionBar");
        this.customCommandBackArrow = this.ultraCosmetics.getConfig().getBoolean("Categories.Back-To-Main-Menu-Custom-Command.Enabled");
        this.customBackMenuCommand = this.ultraCosmetics.getConfig().getString("Categories.Back-To-Main-Menu-Custom-Command.Command").replace("/", "");
        this.closeAfterSelect = this.ultraCosmetics.getConfig().getBoolean("Categories.Close-GUI-After-Select");
        this.cosmeticsProfilesEnabled = this.ultraCosmetics.getConfig().getBoolean("Auto-Equip-Cosmetics");
        this.language = SettingsManager.getConfig().getString("Language");
        this.ammoPurchase = SettingsManager.getConfig().getBoolean("Ammo-System-For-Gadgets.Allow-Purchase");
        this.cosmeticsAffectEntities = SettingsManager.getConfig().getBoolean("Cosmetics-Affect-Entities");
        this.useNMS = SettingsManager.getConfig().getString("Use-NMS", "auto");
        if (this.useNMS.equalsIgnoreCase("false")) {
            this.useNMS = "no";
        }
    }

    public boolean isAmmoEnabled() {
        return this.ammoEnabled;
    }

    public boolean shouldCloseAfterSelect() {
        return this.closeAfterSelect;
    }

    public boolean displaysCooldownInBar() {
        return this.cooldownInBar;
    }

    public boolean usingCustomCommandBackArrow() {
        return this.customCommandBackArrow;
    }

    public boolean usingFileStorage() {
        return this.fileStorage;
    }

    public boolean useMoneyTreasureLoot() {
        return this.moneyTreasureLoot;
    }

    public boolean arePlaceholdersColored() {
        return this.placeHolderColor;
    }

    public boolean areTreasureChestsEnabled() {
        return this.treasureChests;
    }

    public String getCustomBackMenuCommand() {
        return this.customBackMenuCommand;
    }

    public String getLanguage() {
        return this.language;
    }

    public boolean isAmmoPurchaseEnabled() {
        return this.ammoEnabled && this.ammoPurchase;
    }

    public boolean isCosmeticsAffectEntities() {
        return this.cosmeticsAffectEntities;
    }

    public VersionManager getVersionManager() {
        return this.versionManager;
    }

    public ServerVersion getServerVersion() {
        return this.serverVersion;
    }

    public UltraCosmetics getPlugin() {
        return this.ultraCosmetics;
    }

    public boolean areCosmeticsProfilesEnabled() {
        return this.cosmeticsProfilesEnabled;
    }

    public void setFileStorage(boolean fileStorage) {
        this.fileStorage = fileStorage;
    }
}

