/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.command.subcommands;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.command.SubCommand;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.type.CosmeticType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SubCommandToggle
extends SubCommand {
    private static final String ERROR_PREFIX = " " + String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD);

    public SubCommandToggle(UltraCosmetics ultraCosmetics) {
        super("toggle", "Toggles a cosmetic.", "[<type> <cosmetic>] [player]", ultraCosmetics, true);
    }

    @Override
    protected void onExePlayer(Player sender, String[] args) {
        if (args.length < 1 || args.length > 4) {
            this.badUsage((CommandSender)sender);
            return;
        }
        Player target = args.length == 2 || args.length == 4 ? Bukkit.getPlayer((String)args[args.length - 1]) : sender;
        if (args.length < 3) {
            this.toggleAll((CommandSender)sender, target);
        } else {
            this.toggle((CommandSender)sender, target, args[1].toLowerCase(Locale.ROOT), args[2].toLowerCase(Locale.ROOT));
        }
    }

    @Override
    protected void onExeAnyone(CommandSender sender, String[] args) {
        if (args.length != 2 && args.length != 4) {
            this.badUsage(sender, "/uc toggle [<type> <cosmetic>] <player>");
            return;
        }
        this.toggle(sender, Bukkit.getPlayer((String)args[3]), args[1].toLowerCase(Locale.ROOT), args[2].toLowerCase(Locale.ROOT));
    }

    private UltraPlayer commonChecks(CommandSender sender, Player targetPlayer) {
        if (sender != targetPlayer && !sender.hasPermission(this.getPermission().getName() + ".others")) {
            MessageManager.send(sender, "No-Permission", new TagResolver.Single[0]);
            return null;
        }
        UltraPlayer target = this.ultraCosmetics.getPlayerManager().getUltraPlayer(targetPlayer);
        if (target == null) {
            MessageManager.send(sender, "Invalid-Player", new TagResolver.Single[0]);
            return null;
        }
        if (!SettingsManager.isAllowedWorld(target.getBukkitPlayer().getWorld())) {
            MessageManager.send(sender, "World-Disabled", new TagResolver.Single[0]);
            return null;
        }
        return target;
    }

    private void toggleAll(CommandSender sender, Player targetPlayer) {
        UltraPlayer target = this.commonChecks(sender, targetPlayer);
        if (target == null) {
            return;
        }
        if (!target.getProfile().hasAnyEquipped()) {
            this.error(sender, "Please specify the cosmetic to toggle");
            return;
        }
        if (target.hasCosmeticsEquipped()) {
            target.withPreserveEquipped(target::clear);
            MessageManager.send(sender, "Cosmetics-Toggled-Off", new TagResolver.Single[0]);
        } else {
            target.getProfile().equip();
            MessageManager.send(sender, "Cosmetics-Toggled-On", new TagResolver.Single[0]);
        }
    }

    private void toggle(CommandSender sender, Player targetPlayer, String type, String cosm) {
        UltraPlayer target = this.commonChecks(sender, targetPlayer);
        if (target == null) {
            return;
        }
        Optional<Category> categories = Arrays.stream(Category.values()).filter(category -> category.isEnabled() && category.toString().toLowerCase(Locale.ROOT).startsWith(type)).findFirst();
        if (categories.isEmpty()) {
            MessageManager.send(sender, "Invalid-Category", new TagResolver.Single[0]);
            return;
        }
        Category category2 = categories.get();
        CosmeticType<?> matchingType = this.findCosmetic(category2, cosm);
        if (matchingType == null) {
            MessageManager.send(sender, "Invalid-Cosmetic", new TagResolver.Single[0]);
            return;
        }
        if (target.getCosmetic(category2) != null && matchingType == target.getCosmetic(category2).getType()) {
            target.removeCosmetic(category2);
        } else {
            matchingType.equip(target, this.ultraCosmetics);
        }
    }

    private CosmeticType<?> findCosmetic(Category category, String partialName) {
        for (CosmeticType<?> type : category.getEnabled()) {
            if (!type.toString().equalsIgnoreCase(partialName)) continue;
            return type;
        }
        for (CosmeticType<?> type : category.getEnabled()) {
            if (!type.toString().startsWith(partialName.toUpperCase(Locale.ROOT))) continue;
            return type;
        }
        return null;
    }

    @Override
    protected void tabComplete(CommandSender sender, String[] args, List<String> options) {
        if (args.length == 2) {
            this.addCategories(options);
        } else if (args.length == 3) {
            Category cat = Category.fromString(args[1]);
            if (cat == null || !cat.isEnabled()) {
                return;
            }
            for (CosmeticType<?> cosm : cat.getEnabled()) {
                options.add(cosm.toString());
            }
        } else if (args.length == 4) {
            this.addPlayers(options);
        }
    }
}

