/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.command.subcommands;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.command.SubCommand;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.type.CosmeticType;
import be.isach.ultracosmetics.permissions.GrantSource;
import be.isach.ultracosmetics.permissions.PermissionManager;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SubCommandWhyDoIHave
extends SubCommand {
    public SubCommandWhyDoIHave(UltraCosmetics ultraCosmetics) {
        super("whydoihave", "Check what is granting you or another player access to a given cosmetic", "<category> <cosmetic> [player]", ultraCosmetics);
    }

    @Override
    protected void onExePlayer(Player sender, String[] args) {
        Player target;
        if (args.length == 3) {
            target = sender;
        } else if (args.length == 4) {
            target = Bukkit.getPlayer((String)args[3]);
            if (target == null) {
                this.error((CommandSender)sender, "Invalid player");
                return;
            }
        } else {
            this.badUsage((CommandSender)sender);
            return;
        }
        if (!SettingsManager.isAllowedWorld(target.getWorld())) {
            sender.sendMessage("No cosmetics granted because world is disabled");
            return;
        }
        if (this.ultraCosmetics.getWorldGuardManager().isInShowroom(sender)) {
            sender.sendMessage("All cosmetics granted by showroom region");
            return;
        }
        Category cat = Category.fromString(args[1]);
        if (cat == null) {
            this.error((CommandSender)sender, "Invalid category: " + args[1]);
            return;
        }
        CosmeticType<?> type = cat.valueOfType(args[2]);
        if (type == null) {
            this.error((CommandSender)sender, "Invalid cosmetic: " + args[2]);
            return;
        }
        PermissionManager pm = this.ultraCosmetics.getPermissionManager();
        GrantSource source = pm.getGrantSource(target, type);
        if (source == null) {
            sender.sendMessage("Cosmetic is locked");
        } else if (source == GrantSource.PROFILE) {
            Object message = "Cosmetic is granted by UC persistent data (";
            message = UltraCosmeticsData.get().usingFileStorage() ? (String)message + "plugins/UltraCosmetics/data/" : (String)message + "MySQL database";
            message = (String)message + ")";
            sender.sendMessage((String)message);
        } else if (source == GrantSource.PERMISSION) {
            sender.sendMessage("Cosmetic is granted by permissions (" + type.getPermission().getName() + ")");
        }
    }

    @Override
    protected void onExeAnyone(CommandSender sender, String[] args) {
        this.notAllowed(sender);
    }

    @Override
    protected void tabComplete(CommandSender sender, String[] args, List<String> options) {
        if (args.length == 2) {
            this.addCategories(options);
        } else if (args.length == 3) {
            Category cat = Category.fromString(args[1]);
            if (cat == null || !cat.isEnabled()) {
                return;
            }
            for (CosmeticType<?> cosm : cat.getEnabled()) {
                options.add(cosm.toString());
            }
        } else if (args.length == 4) {
            this.addPlayers(options);
        }
    }
}

