/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.config;

import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.CustomConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class SettingsManager {
    public FileConfiguration fileConfiguration;
    private File file;
    private boolean success = true;

    protected SettingsManager(String fileName) {
        File folder = new File(UltraCosmeticsData.get().getPlugin().getDataFolder(), "/data");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        this.file = new File(UltraCosmeticsData.get().getPlugin().getDataFolder(), fileName + ".yml");
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                this.success = false;
                e.printStackTrace();
            }
        }
        this.fileConfiguration = new YamlConfiguration();
        try {
            this.fileConfiguration.load(this.file);
        }
        catch (IOException | InvalidConfigurationException e) {
            this.success = false;
            e.printStackTrace();
        }
    }

    public static CustomConfiguration getConfig() {
        return UltraCosmeticsData.get().getPlugin().getConfig();
    }

    public static SettingsManager getData(Player p) {
        return new SettingsManager("/data/" + String.valueOf(p.getUniqueId()));
    }

    public static SettingsManager getData(UUID uuid) {
        return new SettingsManager("/data/" + uuid.toString());
    }

    public static boolean hasData(UUID uuid) {
        return Arrays.asList(UltraCosmeticsData.get().getPlugin().getDataFolder().listFiles()).contains(new File(uuid.toString() + ".yml"));
    }

    public boolean success() {
        return this.success;
    }

    public void reload() {
        this.fileConfiguration = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public void set(String path, Object value, boolean autosave) {
        this.fileConfiguration.set(path, value);
        if (autosave) {
            this.save();
        }
    }

    public void set(String path, Object value) {
        this.set(path, value, false);
    }

    public void save() {
        try {
            this.fileConfiguration.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean getBoolean(String path) {
        return this.fileConfiguration.getBoolean(path);
    }

    public boolean getBoolean(String path, boolean defaultValue) {
        return this.fileConfiguration.getBoolean(path, defaultValue);
    }

    public int getInt(String path) {
        return this.fileConfiguration.getInt(path);
    }

    public double getDouble(String path) {
        return this.fileConfiguration.getDouble(path);
    }

    public String getString(String path) {
        return this.fileConfiguration.getString(path);
    }

    public List<String> getStringList(String path) {
        return this.fileConfiguration.getStringList(path);
    }

    public boolean addDefault(String path, Object value) {
        if (!this.fileConfiguration.contains(path)) {
            this.set(path, value);
            return true;
        }
        return false;
    }

    public ConfigurationSection createConfigurationSection(String path) {
        return this.fileConfiguration.createSection(path);
    }

    public Object get(String path) {
        return this.fileConfiguration.get(path);
    }

    public boolean contains(String path) {
        return this.fileConfiguration.contains(path);
    }

    public static boolean isAllowedWorld(World world) {
        List worlds = SettingsManager.getConfig().getStringList("Enabled-Worlds");
        if (worlds.contains("*")) {
            return true;
        }
        return worlds.contains(world.getName());
    }

    public ConfigurationSection getConfigurationSection(String path) {
        return this.fileConfiguration.getConfigurationSection(path);
    }
}

