/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.command.CommandManager;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.PlayerAffectingCosmetic;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.type.CosmeticType;
import be.isach.ultracosmetics.events.UCCosmeticEquipEvent;
import be.isach.ultracosmetics.events.UCCosmeticUnequipEvent;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.Component;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import be.isach.ultracosmetics.shaded.tcoded.folialib.wrapper.task.WrappedTask;
import be.isach.ultracosmetics.util.TextUtil;
import be.isach.ultracosmetics.worldguard.CosmeticRegionState;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public abstract class Cosmetic<T extends CosmeticType<?>>
implements Listener {
    protected static final Random RANDOM = new Random();
    private final UltraPlayer owner;
    private final Category category;
    private final UltraCosmetics ultraCosmetics;
    protected boolean equipped;
    protected final T cosmeticType;
    private final UUID ownerUniqueId;
    private final Component typeName;
    protected WrappedTask task;

    public Cosmetic(UltraPlayer owner, T type, UltraCosmetics ultraCosmetics) {
        if (owner == null || owner.getBukkitPlayer() == null) {
            throw new IllegalArgumentException("Invalid UltraPlayer.");
        }
        this.owner = owner;
        this.ownerUniqueId = owner.getUUID();
        this.category = ((CosmeticType)type).getCategory();
        this.ultraCosmetics = ultraCosmetics;
        this.cosmeticType = type;
        this.typeName = ((CosmeticType)type).getName();
    }

    public final void equip() {
        Player player = this.getPlayer();
        if (!((CosmeticType)this.cosmeticType).isEnabled()) {
            MessageManager.send((CommandSender)player, "Cosmetic-Disabled", new TagResolver.Single[0]);
            return;
        }
        if (!this.owner.canEquip((CosmeticType<?>)this.cosmeticType)) {
            CommandManager.sendNoPermissionMessage((CommandSender)player);
            return;
        }
        if (PlayerAffectingCosmetic.isVanished(player) && SettingsManager.getConfig().getBoolean("Prevent-Cosmetics-In-Vanish")) {
            this.owner.clear();
            MessageManager.send((CommandSender)player, "Not-Allowed-In-Vanish", new TagResolver.Single[0]);
            return;
        }
        CosmeticRegionState state = this.ultraCosmetics.getWorldGuardManager().allowedCosmeticsState(player, this.category);
        if (state == CosmeticRegionState.BLOCKED_ALL) {
            MessageManager.send((CommandSender)player, "Region-Disabled", new TagResolver.Single[0]);
            return;
        }
        if (state == CosmeticRegionState.BLOCKED_CATEGORY) {
            TagResolver.Single placeholder = Placeholder.component("category", TextUtil.stripColor(MessageManager.getMessage("Menu." + this.category.getConfigPath() + ".Title", new TagResolver.Single[0])));
            MessageManager.send((CommandSender)player, "Region-Disabled-Category", placeholder);
            return;
        }
        if (!this.tryEquip()) {
            return;
        }
        UCCosmeticEquipEvent event = new UCCosmeticEquipEvent(this.owner, this);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.ultraCosmetics.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.ultraCosmetics);
        this.unequipLikeCosmetics();
        this.equipped = true;
        if (!this.owner.isPreserveEquipped()) {
            TagResolver.Single typeNamePlaceholder = Placeholder.component(this.getCategory().getChatPlaceholder(), TextUtil.filterPlaceholderColors(this.typeName));
            Component activateMessage = MessageManager.getMessage(this.category.getConfigPath() + ".Equip", typeNamePlaceholder);
            this.owner.sendMessage(this.appendActivateMessage(activateMessage));
        }
        if (this instanceof Updatable) {
            this.scheduleTask();
        }
        this.onEquip();
        this.getOwner().setCosmeticEquipped(this);
    }

    public void clear() {
        UCCosmeticUnequipEvent event = new UCCosmeticUnequipEvent(this.owner, this);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!this.owner.isPreserveEquipped()) {
            TagResolver.Single typeNamePlaceholder = Placeholder.component(this.getCategory().getChatPlaceholder(), TextUtil.filterPlaceholderColors(this.typeName));
            Component deactivateMessage = MessageManager.getMessage(this.category.getConfigPath() + ".Unequip", typeNamePlaceholder);
            this.owner.sendMessage(deactivateMessage);
        }
        HandlerList.unregisterAll((Listener)this);
        try {
            if (this.task != null) {
                this.task.cancel();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.onClear();
        this.unsetCosmetic();
    }

    protected void cancelTask() {
        if (this.task != null) {
            this.task.cancel();
        }
    }

    protected void scheduleTask() {
        this.task = this.ultraCosmetics.getScheduler().runAtEntityTimer((Entity)this.getPlayer(), this::run, 1L, 1L);
    }

    protected void unsetCosmetic() {
        this.owner.unsetCosmetic(this.category);
    }

    protected void unequipLikeCosmetics() {
        this.getOwner().removeCosmetic(this.category);
    }

    protected boolean tryEquip() {
        return true;
    }

    public void run() {
        if (this.getPlayer() == null || this.getOwner().getCosmetic(this.category) != this) {
            return;
        }
        ((Updatable)((Object)this)).onUpdate();
    }

    protected abstract void onEquip();

    protected void onClear() {
    }

    public final UltraPlayer getOwner() {
        return this.owner;
    }

    public final UltraCosmetics getUltraCosmetics() {
        return this.ultraCosmetics;
    }

    public final Category getCategory() {
        return this.category;
    }

    public final Player getPlayer() {
        return this.owner.getBukkitPlayer();
    }

    public boolean isEquipped() {
        return this.equipped;
    }

    public final UUID getOwnerUniqueId() {
        return this.ownerUniqueId;
    }

    public T getType() {
        return this.cosmeticType;
    }

    public Component getTypeName() {
        return this.typeName;
    }

    protected Component appendActivateMessage(Component base) {
        return base;
    }

    protected String getOptionPath(String key) {
        return ((CosmeticType)this.cosmeticType).getConfigPath() + "." + key;
    }
}

