/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.emotes;

import be.isach.ultracosmetics.cosmetics.emotes.Emote;
import be.isach.ultracosmetics.cosmetics.type.EmoteType;
import be.isach.ultracosmetics.shaded.tcoded.folialib.wrapper.task.WrappedTask;
import org.bukkit.entity.Entity;

class EmoteAnimation {
    private static final int INTERVAL_BETWEEN_REPLAY = 20;
    private int ticks;
    private final int ticksPerFrame;
    private int currentFrame;
    private int intervalTick;
    private final Emote emote;
    private boolean running;
    private boolean up = true;
    private WrappedTask task;

    EmoteAnimation(int ticksPerFrame, Emote emote) {
        this.ticksPerFrame = ticksPerFrame;
        this.emote = emote;
        this.ticks = 0;
        this.running = false;
    }

    public void run() {
        if (this.ticks < this.ticksPerFrame) {
            ++this.ticks;
        } else {
            this.ticks = 0;
            this.updateTexture();
        }
    }

    void start() {
        this.running = true;
        this.task = this.emote.getUltraCosmetics().getScheduler().runAtEntityTimer((Entity)this.emote.getPlayer(), this::run, 1L, (long)this.ticksPerFrame);
    }

    void stop() {
        if (!this.running) {
            return;
        }
        this.running = false;
        try {
            if (this.task != null) {
                this.task.cancel();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void updateTexture() {
        if (!this.running) {
            return;
        }
        this.emote.setItemStack(((EmoteType)this.emote.getType()).getFrames().get(this.currentFrame));
        if (this.up) {
            if (this.currentFrame >= ((EmoteType)this.emote.getType()).getMaxFrames() - 1) {
                this.up = false;
            } else {
                ++this.currentFrame;
            }
        } else if (this.currentFrame <= 0) {
            if (this.intervalTick >= 20 / this.ticksPerFrame) {
                this.up = true;
                this.intervalTick = 0;
            } else {
                ++this.intervalTick;
            }
        } else {
            --this.currentFrame;
        }
    }
}

