/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.gadgets;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.cosmetics.PlayerAffectingCosmetic;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.gadgets.Gadget;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.player.UltraPlayer;
import com.cryptomorin.xseries.XMaterial;
import com.cryptomorin.xseries.particles.ParticleDisplay;
import com.cryptomorin.xseries.particles.XParticle;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class GadgetAntiGravity
extends Gadget
implements PlayerAffectingCosmetic,
Updatable {
    private static final ItemStack SEA_LANTERN = XMaterial.SEA_LANTERN.parseItem();
    private ArmorStand as;
    private boolean running;
    private ParticleDisplay portalParticles;
    private ParticleDisplay witchParticles;

    public GadgetAntiGravity(UltraPlayer owner, GadgetType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    protected void onRightClick() {
        this.as = (ArmorStand)this.getPlayer().getWorld().spawn(this.getPlayer().getLocation(), ArmorStand.class);
        this.as.setMetadata("NO_INTER", (MetadataValue)new FixedMetadataValue((Plugin)this.getUltraCosmetics(), (Object)""));
        this.as.setPersistent(false);
        this.as.setGravity(false);
        this.as.setSmall(true);
        this.running = true;
        this.as.setVisible(false);
        this.as.getEquipment().setHelmet(SEA_LANTERN);
        this.portalParticles = ParticleDisplay.of((XParticle)XParticle.PORTAL).offset(3.0, 3.0, 3.0).withCount(150).withLocation(this.as.getLocation());
        this.witchParticles = ParticleDisplay.of((XParticle)XParticle.WITCH).offset(0.3, 0.3, 0.3).withCount(5).withLocation(this.as.getEyeLocation());
        this.getUltraCosmetics().getScheduler().runLaterAsync(() -> {
            this.running = false;
        }, 240L);
    }

    @Override
    public void onUpdate() {
        if (this.as == null || !this.as.isValid()) {
            return;
        }
        if (!this.running) {
            this.as.remove();
            this.as = null;
            return;
        }
        this.as.setHeadPose(this.as.getHeadPose().add(0.0, 0.1, 0.0));
        this.portalParticles.spawn();
        this.witchParticles.spawn();
        for (Entity ent : this.as.getNearbyEntities(3.0, 2.0, 3.0)) {
            if (!this.canAffect(ent, this.getPlayer())) continue;
            LivingEntity le = (LivingEntity)ent;
            le.addPotionEffect(new PotionEffect(PotionEffectType.LEVITATION, 5, 0));
        }
    }

    @Override
    public void onClear() {
        if (this.as != null) {
            this.as.remove();
        }
        this.running = false;
    }
}

