/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.gadgets;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.cosmetics.PlayerAffectingCosmetic;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.gadgets.Gadget;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.util.ItemFactory;
import be.isach.ultracosmetics.util.MathUtils;
import com.cryptomorin.xseries.XMaterial;
import com.cryptomorin.xseries.particles.ParticleDisplay;
import com.cryptomorin.xseries.particles.XParticle;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class GadgetBlackHole
extends Gadget
implements PlayerAffectingCosmetic,
Updatable {
    private static final ParticleDisplay PARTICLES = ParticleDisplay.of((XParticle)XParticle.LARGE_SMOKE);
    private Item item;

    public GadgetBlackHole(UltraPlayer owner, GadgetType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    protected void onRightClick() {
        if (this.item != null) {
            this.item.remove();
        }
        this.item = ItemFactory.spawnUnpickableItem(XMaterial.BLACK_TERRACOTTA.parseItem(), this.getPlayer().getEyeLocation(), this.getPlayer().getEyeLocation().getDirection().multiply(1.3));
        this.getUltraCosmetics().getScheduler().runAtLocationLater(this.getPlayer().getLocation(), () -> {
            if (this.item != null) {
                this.item.remove();
                this.item = null;
            }
        }, 140L);
    }

    @Override
    public void onUpdate() {
        if (this.item == null || !this.item.isOnGround()) {
            return;
        }
        int strands = 6;
        int particles = 25;
        float radius = 5.0f;
        float curve = 10.0f;
        double rotation = 0.7853981633974483;
        Location location = this.item.getLocation();
        for (int i = 1; i <= strands; ++i) {
            for (int j = 1; j <= particles; ++j) {
                float ratio = (float)j / (float)particles;
                double angle = (double)(curve * ratio * 2.0f) * Math.PI / (double)strands + Math.PI * 2 * (double)i / (double)strands + rotation;
                double x = Math.cos(angle) * (double)ratio * (double)radius;
                double z = Math.sin(angle) * (double)ratio * (double)radius;
                location.add(x, 0.0, z);
                PARTICLES.spawn(location);
                location.subtract(x, 0.0, z);
            }
        }
        if (!this.isAffectingPlayersEnabled()) {
            return;
        }
        for (Entity entity : this.item.getNearbyEntities(5.0, 3.0, 5.0)) {
            if (!this.canAffect(entity, this.getPlayer())) continue;
            Vector vector = this.item.getLocation().toVector().subtract(entity.getLocation().toVector());
            MathUtils.applyVelocity(entity, vector);
            if (!(entity instanceof Player)) continue;
            ((Player)entity).addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 40, 40));
        }
    }

    @Override
    public void onClear() {
        if (this.item != null) {
            this.item.remove();
        }
    }
}

