/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.gadgets;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.cosmetics.PlayerAffectingCosmetic;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.gadgets.Gadget;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.util.BlockUtils;
import com.cryptomorin.xseries.particles.ParticleDisplay;
import com.cryptomorin.xseries.particles.XParticle;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class GadgetBlizzardBlaster
extends Gadget
implements PlayerAffectingCosmetic,
Updatable {
    private final ParticleDisplay display = ParticleDisplay.of((XParticle)XParticle.CLOUD).withCount(6).offset(0.3, 0.1, 0.3).withExtra(0.4);
    private boolean active;
    private Location location;
    private Vector vector;

    public GadgetBlizzardBlaster(UltraPlayer owner, GadgetType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    protected void onRightClick() {
        this.vector = this.getPlayer().getLocation().getDirection().normalize().multiply(0.3);
        this.vector.setY(0);
        this.location = this.getPlayer().getLocation().subtract(0.0, 1.0, 0.0).add(this.vector);
        this.active = true;
        this.getUltraCosmetics().getScheduler().runAtEntityLater((Entity)this.getPlayer(), () -> {
            this.active = false;
        }, 40L);
    }

    @Override
    public void onUpdate() {
        if (this.active) {
            if (this.location.getBlock().getType().isSolid()) {
                this.location.add(0.0, 1.0, 0.0);
            }
            if (BlockUtils.isAir(this.location.clone().subtract(0.0, 1.0, 0.0).getBlock().getType()) && !this.location.clone().getBlock().getType().toString().contains("SLAB")) {
                this.location.add(0.0, -1.0, 0.0);
            }
            for (int i = 0; i < 3; ++i) {
                UltraCosmeticsData.get().getVersionManager().getEntityUtil().sendBlizzard(this.getPlayer(), this.location, entity -> this.canAffect((Entity)entity, this.getPlayer()), this.vector);
            }
            this.display.spawn(this.location.clone().subtract(0.0, 0.5, 0.0));
            this.location.add(this.vector);
        } else {
            this.location = null;
            this.vector = null;
        }
    }

    @Override
    public void onClear() {
        if (this.getOwner() == null || this.getPlayer() == null) {
            return;
        }
        UltraCosmeticsData.get().getVersionManager().getEntityUtil().clearBlizzard(this.getPlayer());
    }
}

