/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.gadgets;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.cosmetics.gadgets.Gadget;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.util.EntitySpawner;
import be.isach.ultracosmetics.util.ItemFactory;
import com.cryptomorin.xseries.XMaterial;
import com.cryptomorin.xseries.XSound;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;

public class GadgetChickenator
extends Gadget {
    private final List<Item> items = new ArrayList<Item>();
    private final XSound.SoundPlayer ambient = XSound.ENTITY_CHICKEN_AMBIENT.record().withVolume(1.4f).withPitch(1.5f).soundPlayer().forPlayers(new Player[]{this.getPlayer()});
    private final XSound.SoundPlayer explode = XSound.ENTITY_GENERIC_EXPLODE.record().withVolume(0.3f).withPitch(1.5f).soundPlayer().forPlayers(new Player[]{this.getPlayer()});
    private final XSound.SoundPlayer hurt = XSound.ENTITY_CHICKEN_HURT.record().withVolume(1.4f).withPitch(1.5f).soundPlayer().forPlayers(new Player[]{this.getPlayer()});

    public GadgetChickenator(UltraPlayer owner, GadgetType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    protected void onRightClick() {
        Chicken chicken = (Chicken)this.getPlayer().getWorld().spawnEntity(this.getPlayer().getEyeLocation(), EntityType.CHICKEN);
        chicken.setNoDamageTicks(500);
        chicken.setVelocity(this.getPlayer().getLocation().getDirection().multiply(2.0943951023931953));
        this.ambient.play();
        this.explode.play();
        this.getUltraCosmetics().getScheduler().runAtEntityLater((Entity)this.getPlayer(), () -> {
            EntitySpawner.spawnFireworks(chicken.getLocation(), Color.WHITE, Color.WHITE);
            this.hurt.play();
            chicken.remove();
            for (int i = 0; i < 30; ++i) {
                this.items.add(ItemFactory.createUnpickableItemVariance(XMaterial.COOKED_CHICKEN, chicken.getLocation(), RANDOM, 1.0));
            }
            this.getUltraCosmetics().getScheduler().runAtEntityLater((Entity)this.getPlayer(), () -> this.items.forEach(Entity::remove), 50L);
        }, 9L);
        this.getPlayer().updateInventory();
    }

    @Override
    public void onClear() {
        for (Item i : this.items) {
            i.remove();
        }
        this.items.clear();
    }
}

