/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.gadgets;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.cosmetics.PlayerAffectingCosmetic;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.gadgets.Gadget;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.util.ItemFactory;
import be.isach.ultracosmetics.util.MathUtils;
import com.cryptomorin.xseries.XMaterial;
import com.cryptomorin.xseries.XSound;
import com.cryptomorin.xseries.XTag;
import com.cryptomorin.xseries.particles.ParticleDisplay;
import com.cryptomorin.xseries.particles.XParticle;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class GadgetColorBomb
extends Gadget
implements PlayerAffectingCosmetic,
Updatable {
    private Item bomb;
    private final Set<Item> items = new HashSet<Item>();
    private boolean running = false;
    private final XSound.SoundPlayer sound = XSound.ENTITY_CHICKEN_EGG.record().withVolume(0.2f).soundPlayer();
    private final ParticleDisplay particle = new ParticleDisplay().withLocationCaller(() -> this.bomb.getLocation()).withExtra(0.2);

    public GadgetColorBomb(UltraPlayer owner, GadgetType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    protected void onRightClick() {
        this.bomb = ItemFactory.createUnpickableItemDirectional(ItemFactory.randomFromTag((XTag<XMaterial>)XTag.WOOL), this.getPlayer(), 0.7532);
    }

    @Override
    public void onUpdate() {
        if (this.bomb == null || !this.bomb.isValid()) {
            return;
        }
        if (!this.running && this.bomb.isOnGround()) {
            this.running = true;
            this.bomb.setVelocity(new Vector(0, 0, 0));
            this.getUltraCosmetics().getScheduler().runAtEntityLater((Entity)this.bomb, this::onClear, 100L);
        }
        if (!this.running) {
            return;
        }
        switch (RANDOM.nextInt(5)) {
            default: {
                this.particle.withParticle(XParticle.FIREWORK);
                break;
            }
            case 3: {
                this.particle.withParticle(XParticle.FLAME);
                break;
            }
            case 4: {
                this.particle.withParticle(XParticle.WITCH);
            }
        }
        this.particle.spawn();
        Iterator<Item> iter = this.items.iterator();
        while (iter.hasNext()) {
            Item item = iter.next();
            if (item.getTicksLived() <= 15) continue;
            item.remove();
            iter.remove();
        }
        this.getUltraCosmetics().getScheduler().runAtEntity((Entity)this.getPlayer(), task -> {
            if (this.bomb == null) {
                return;
            }
            Vector velocity = new Vector(0.0, 0.5, 0.0).add(MathUtils.getRandomCircleVector().multiply(0.1));
            Item item = ItemFactory.spawnUnpickableItem(ItemFactory.randomItemFromTag((XTag<XMaterial>)XTag.WOOL), this.bomb.getLocation().add(0.0, 0.15, 0.0), velocity);
            this.items.add(item);
            this.sound.atLocation(item.getLocation()).play();
            Player player = this.getPlayer();
            for (Entity entity : this.bomb.getNearbyEntities(1.5, 1.0, 1.5)) {
                if (!(entity instanceof Player) || !this.canAffect(entity, player)) continue;
                MathUtils.applyVelocity(entity, new Vector(0.0, 0.5, 0.0).add(MathUtils.getRandomCircleVector().multiply(0.1)));
            }
        });
    }

    @Override
    public void onClear() {
        if (this.bomb != null) {
            this.bomb.remove();
            this.bomb = null;
        }
        for (Item item : this.items) {
            item.remove();
        }
        this.items.clear();
        this.running = false;
    }
}

