/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.gadgets;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.cosmetics.PlayerAffectingCosmetic;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.gadgets.Gadget;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import be.isach.ultracosmetics.util.Area;
import be.isach.ultracosmetics.util.BlockUtils;
import be.isach.ultracosmetics.util.ItemFactory;
import be.isach.ultracosmetics.util.MathUtils;
import com.cryptomorin.xseries.XMaterial;
import com.cryptomorin.xseries.XTag;
import com.cryptomorin.xseries.base.XBase;
import com.cryptomorin.xseries.particles.ParticleDisplay;
import com.cryptomorin.xseries.particles.XParticle;
import java.awt.Color;
import java.util.HashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class GadgetDiscoBall
extends Gadget
implements PlayerAffectingCosmetic,
Updatable {
    private double i = 0.0;
    private ArmorStand armorStand;
    private boolean running = false;
    private final ParticleDisplay effect = ParticleDisplay.of((XParticle)XParticle.EFFECT).withLocationCaller(() -> this.armorStand.getEyeLocation());
    private final ParticleDisplay instantEffect = ParticleDisplay.of((XParticle)XParticle.INSTANT_EFFECT).withLocationCaller(() -> this.armorStand.getEyeLocation());
    private final ParticleDisplay note = ParticleDisplay.of((XParticle)XParticle.NOTE).withCount(0);
    private final ParticleDisplay dust = ParticleDisplay.of((XParticle)XParticle.DUST);

    public GadgetDiscoBall(UltraPlayer owner, GadgetType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    protected void onRightClick() {
        this.armorStand = (ArmorStand)this.getPlayer().getWorld().spawnEntity(this.getPlayer().getLocation().add(0.0, 3.0, 0.0), EntityType.ARMOR_STAND);
        this.armorStand.setMetadata("NO_INTER", (MetadataValue)new FixedMetadataValue((Plugin)this.getUltraCosmetics(), (Object)""));
        this.armorStand.setVisible(false);
        this.armorStand.setGravity(false);
        this.armorStand.setSmall(false);
        this.armorStand.setPersistent(false);
        this.armorStand.getEquipment().setHelmet(ItemFactory.create(XMaterial.LIGHT_BLUE_STAINED_GLASS, " ", new String[0]));
        this.running = true;
        this.getUltraCosmetics().getScheduler().runAtEntityLater((Entity)this.getPlayer(), this::clean, 400L);
    }

    @Override
    protected boolean checkRequirements(PlayerInteractEvent event) {
        Area area = new Area(this.getPlayer().getLocation(), 0, 4);
        if (!area.isEmpty()) {
            MessageManager.send((CommandSender)this.getPlayer(), "Gadgets.DiscoBall.Not-Space-Above", new TagResolver.Single[0]);
            return false;
        }
        return true;
    }

    @Override
    public void onUpdate() {
        if (this.armorStand == null) {
            return;
        }
        if (!this.armorStand.isValid() || !this.running) {
            this.i = 0.0;
            this.clean();
            return;
        }
        this.armorStand.setHeadPose(this.armorStand.getHeadPose().add(0.0, 0.2, 0.0));
        this.armorStand.getEquipment().setHelmet(ItemFactory.getRandomStainedGlass());
        this.effect.spawn();
        this.instantEffect.spawn();
        Location loc = this.armorStand.getEyeLocation().add(MathUtils.randomDouble(-4.0, 4.0), MathUtils.randomDouble(-3.0, 3.0), MathUtils.randomDouble(-4.0, 4.0));
        this.note.withColor(new Color(RANDOM.nextInt(256), 0, 0)).spawn(loc);
        double angle = Math.PI * 2 * this.i / 100.0;
        double x = Math.cos(angle) * 4.0;
        double z = Math.sin(angle) * 4.0;
        this.drawParticleLine(this.armorStand.getEyeLocation(), this.armorStand.getEyeLocation().add(x, 0.0, z), 50);
        this.i += 0.4;
        XTag tag = null;
        HashMap<Block, XMaterial> updates = new HashMap<Block, XMaterial>();
        for (Block b : BlockUtils.getBlocksInRadius(this.armorStand.getEyeLocation().add(-0.5, -0.5, -0.5), 10, false)) {
            XMaterial mat = XMaterial.matchXMaterial((Material)b.getType());
            if (XTag.WOOL.isTagged((XBase)mat)) {
                tag = XTag.WOOL;
            } else if (XTag.CARPETS.isTagged((XBase)mat)) {
                tag = XTag.CARPETS;
            }
            if (tag == null) continue;
            updates.put(b, ItemFactory.randomFromTag((XTag<XMaterial>)tag));
            tag = null;
        }
        BlockUtils.setToRestore(updates, 4);
        Player player = this.getPlayer();
        for (Entity ent : loc.getWorld().getNearbyEntities(this.armorStand.getEyeLocation().add(-0.5, -0.5, -0.5), 7.5, 7.5, 7.5)) {
            if (!ent.isOnGround() || !this.canAffect(ent, player)) continue;
            MathUtils.applyVelocity(ent, new Vector(0.0, 0.3, 0.0));
        }
    }

    private void clean() {
        this.running = false;
        if (this.armorStand != null) {
            this.armorStand.remove();
            this.armorStand = null;
        }
    }

    @Override
    public void onClear() {
        this.clean();
    }

    public void drawParticleLine(Location a, Location b, int particles) {
        Location location = a.clone();
        Location target = b.clone();
        Vector link = target.toVector().subtract(location.toVector());
        float length = (float)link.length();
        link.normalize();
        float ratio = length / (float)particles;
        Vector v = link.multiply(ratio);
        MathUtils.rotateAroundAxisX(v, this.i / 5.0);
        MathUtils.rotateAroundAxisZ(v, this.i / 5.0);
        Location loc = location.clone().subtract(v);
        for (int i = 0; i < particles; ++i) {
            loc.add(v);
            this.dust.withColor(new Color(MathUtils.random(255), MathUtils.random(255), MathUtils.random(255))).spawn(loc);
        }
    }
}

