/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.gadgets;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.cosmetics.gadgets.Gadget;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.mobchip.EntityBrain;
import be.isach.ultracosmetics.shaded.mobchip.ai.goal.PathfinderPanic;
import be.isach.ultracosmetics.shaded.mobchip.bukkit.BukkitBrain;
import be.isach.ultracosmetics.shaded.tcoded.folialib.wrapper.task.WrappedTask;
import be.isach.ultracosmetics.util.EntitySpawner;
import be.isach.ultracosmetics.util.MathUtils;
import com.cryptomorin.xseries.XSound;
import com.cryptomorin.xseries.particles.ParticleDisplay;
import com.cryptomorin.xseries.particles.XParticle;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sheep;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.util.Vector;

public class GadgetExplosiveSheep
extends Gadget {
    private final Set<Sheep> sheeps = new HashSet<Sheep>();
    private WrappedTask sheepRemovalRunnable = null;
    private final XSound.SoundPlayer tickSound = XSound.BLOCK_NOTE_BLOCK_HAT.record().withVolume(1.4f).withPitch(1.5f).soundPlayer();
    private final XSound.SoundPlayer explodeSound = XSound.ENTITY_GENERIC_EXPLODE.record().withVolume(1.4f).withPitch(1.5f).soundPlayer();
    private final ParticleDisplay emitter = ParticleDisplay.of((XParticle)XParticle.EXPLOSION_EMITTER);
    private final ParticleDisplay lava = ParticleDisplay.of((XParticle)XParticle.LAVA).withCount(5);

    public GadgetExplosiveSheep(UltraPlayer owner, GadgetType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    protected void onRightClick() {
        Location loc = this.getPlayer().getLocation().add(this.getPlayer().getEyeLocation().getDirection().multiply(0.5));
        loc.setY((double)(this.getPlayer().getLocation().getBlockY() + 1));
        Sheep sheep = (Sheep)this.getPlayer().getWorld().spawn(loc, Sheep.class);
        sheep.setNoDamageTicks(100000);
        this.sheeps.add(sheep);
        EntityBrain brain = BukkitBrain.getBrain((Mob)sheep);
        brain.getGoalAI().clear();
        brain.getTargetAI().clear();
        new SheepColorRunnable(sheep, 7.0, true);
    }

    @EventHandler
    public void onShear(PlayerShearEntityEvent event) {
        if (this.sheeps.contains(event.getEntity())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onDamage(EntityDamageEvent event) {
        if (this.sheeps.contains(event.getEntity())) {
            event.setCancelled(true);
        }
    }

    @Override
    public void onClear() {
        for (Sheep sheep : this.sheeps) {
            sheep.remove();
        }
        if (this.sheepRemovalRunnable != null) {
            this.sheepRemovalRunnable.cancel();
        }
    }

    private class SheepColorRunnable {
        private final Sheep s;
        private boolean red;
        private double time;
        private final WrappedTask task;

        private SheepColorRunnable(Sheep s, double time, boolean red) {
            this.s = s;
            this.red = red;
            this.time = time;
            this.task = GadgetExplosiveSheep.this.getUltraCosmetics().getScheduler().runAtEntityLater((Entity)s, this::run, (long)((int)time));
        }

        public void run() {
            if (GadgetExplosiveSheep.this.getOwner() == null || GadgetExplosiveSheep.this.getPlayer() == null || !this.s.isValid()) {
                this.task.cancel();
                return;
            }
            this.s.setColor(this.red ? DyeColor.RED : DyeColor.WHITE);
            GadgetExplosiveSheep.this.tickSound.atLocation(this.s.getLocation()).play();
            this.red = !this.red;
            this.time -= 0.2;
            if (this.time >= 0.5) {
                new SheepColorRunnable(this.s, this.time, this.red);
                return;
            }
            GadgetExplosiveSheep.this.explodeSound.atLocation(this.s.getLocation()).play();
            GadgetExplosiveSheep.this.emitter.spawn(this.s.getLocation());
            GadgetExplosiveSheep.this.sheeps.remove(this.s);
            this.s.remove();
            DyeColor[] colors = DyeColor.values();
            Player player = GadgetExplosiveSheep.this.getPlayer();
            EntitySpawner<Sheep> sheeps = new EntitySpawner<Sheep>(EntityType.SHEEP, this.s.getLocation(), 50, sheep -> {
                sheep.setColor(colors[RANDOM.nextInt(colors.length)]);
                MathUtils.applyVelocity((Entity)sheep, new Vector(RANDOM.nextDouble() - 0.5, RANDOM.nextDouble() / 2.0, RANDOM.nextDouble() - 0.5).multiply(2).add(new Vector(0.0, 0.8, 0.0)));
                sheep.setBaby();
                sheep.setAgeLock(true);
                sheep.setNoDamageTicks(120);
                EntityBrain brain = BukkitBrain.getBrain((Mob)sheep);
                brain.getGoalAI().clear();
                brain.getTargetAI().clear();
                sheep.damage(1.0, (Entity)player);
                brain.getGoalAI().put(new PathfinderPanic((Creature)sheep, 2.0), 0);
                GadgetExplosiveSheep.this.sheeps.add((Sheep)sheep);
            }, GadgetExplosiveSheep.this.getUltraCosmetics());
            GadgetExplosiveSheep.this.sheepRemovalRunnable = GadgetExplosiveSheep.this.getUltraCosmetics().getScheduler().runAtEntityLater((Entity)player, () -> {
                for (Sheep sheep : sheeps.getEntities()) {
                    GadgetExplosiveSheep.this.lava.spawn(sheep.getLocation());
                    GadgetExplosiveSheep.this.sheeps.remove(sheep);
                }
                sheeps.removeEntities();
            }, 110L);
        }
    }
}

