/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.gadgets;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.cosmetics.PlayerAffectingCosmetic;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.gadgets.Gadget;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import be.isach.ultracosmetics.util.ItemFactory;
import com.cryptomorin.xseries.XMaterial;
import com.cryptomorin.xseries.XSound;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Effect;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.ItemMergeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class GadgetMelonThrower
extends Gadget
implements PlayerAffectingCosmetic,
Updatable {
    private Item melon = null;
    private final Set<Item> melonSlices = new HashSet<Item>();
    private final XSound.SoundPlayer eatSound = XSound.ENTITY_PLAYER_BURP.record().withVolume(1.4f).withPitch(1.5f).soundPlayer();
    private final XSound.SoundPlayer useSound = XSound.ENTITY_GENERIC_EXPLODE.record().withVolume(1.4f).withPitch(1.5f).soundPlayer();

    public GadgetMelonThrower(UltraPlayer owner, GadgetType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @EventHandler
    public void onTakeUpMelon(EntityPickupItemEvent event) {
        if (!this.melonSlices.contains(event.getItem())) {
            return;
        }
        event.setCancelled(true);
        if (event.getEntityType() == EntityType.PLAYER && event.getItem().getTicksLived() > 5 && this.canAffect((Entity)event.getEntity(), this.getPlayer())) {
            event.getEntity().addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 100, 2));
            this.eatSound.atLocation(this.getPlayer().getLocation()).play();
            event.getItem().remove();
            this.melonSlices.remove(event.getItem());
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onItemMerge(ItemMergeEvent event) {
        if (this.melonSlices.contains(event.getEntity()) || this.melonSlices.contains(event.getTarget())) {
            event.setCancelled(true);
        }
    }

    @Override
    protected boolean checkRequirements(PlayerInteractEvent event) {
        if (this.melon != null && this.melon.isValid()) {
            MessageManager.send((CommandSender)this.getPlayer(), "Gadgets.MelonThrower.Wait-For-Finish", new TagResolver.Single[0]);
            return false;
        }
        return true;
    }

    @Override
    protected void onRightClick() {
        Player player = this.getPlayer();
        this.useSound.atLocation(player.getLocation()).play();
        this.melon = ItemFactory.createUnpickableItemDirectional(XMaterial.MELON, player, 1.3);
    }

    @Override
    public void onUpdate() {
        if (this.melon == null || !this.melon.isValid()) {
            this.melon = null;
            return;
        }
        if (this.melon.isOnGround()) {
            this.melon.getWorld().playEffect(this.melon.getLocation(), Effect.STEP_SOUND, 103);
            for (int i = 0; i < 8; ++i) {
                this.melonSlices.add(ItemFactory.createUnpickableItemVariance(XMaterial.MELON_SLICE, this.melon.getLocation(), RANDOM, 0.75));
            }
            this.getUltraCosmetics().getScheduler().runAtEntityLater((Entity)this.getPlayer(), () -> {
                for (Item slice : this.melonSlices) {
                    slice.remove();
                }
                this.melonSlices.clear();
            }, 100L);
            this.melon.remove();
            this.melon = null;
        }
    }

    @Override
    public void onClear() {
        if (this.melon != null) {
            this.melon.remove();
        }
        for (Item slice : this.melonSlices) {
            slice.remove();
        }
        this.melonSlices.clear();
    }
}

