/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.morphs;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.morphs.MorphNoFall;
import be.isach.ultracosmetics.cosmetics.type.MorphType;
import be.isach.ultracosmetics.player.UltraPlayer;
import com.cryptomorin.xseries.XSound;
import com.cryptomorin.xseries.particles.ParticleDisplay;
import com.cryptomorin.xseries.particles.XParticle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerKickEvent;

public class MorphBlaze
extends MorphNoFall
implements Updatable {
    private final XSound.SoundPlayer sound = XSound.BLOCK_FIRE_EXTINGUISH.record().withVolume(0.1f).withPitch(1.5f).soundPlayer().forPlayers(new Player[]{this.getPlayer()});
    private final ParticleDisplay flameDisplay = ParticleDisplay.of((XParticle)XParticle.FLAME).withEntity((Entity)this.getPlayer());
    private final ParticleDisplay lavaDisplay = ParticleDisplay.of((XParticle)XParticle.LAVA).withEntity((Entity)this.getPlayer());

    public MorphBlaze(UltraPlayer owner, MorphType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    public void onUpdate() {
        if (this.canUseSkill && this.getPlayer().isSneaking()) {
            this.flameDisplay.spawn();
            this.lavaDisplay.spawn();
            this.sound.play();
            this.getPlayer().setVelocity(this.getPlayer().getEyeLocation().getDirection().multiply(1));
        }
    }

    @EventHandler
    public void onKick(PlayerKickEvent event) {
        if (this.canUseSkill && event.getPlayer() == this.getPlayer() && this.getOwner().getCurrentMorph() == this && event.getReason().contains("Flying")) {
            event.setCancelled(true);
        }
    }
}

