/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.morphs;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.morphs.MorphNoFall;
import be.isach.ultracosmetics.cosmetics.type.MorphType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.util.BlockUtils;
import be.isach.ultracosmetics.util.EntitySpawner;
import org.bukkit.Color;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.util.Vector;

public class MorphEnderman
extends MorphNoFall {
    private static final double COOLDOWN = 3.5;
    private final String mode = SettingsManager.getConfig().getString(this.getOptionPath("Mode"), "Ray trace");

    public MorphEnderman(UltraPlayer owner, MorphType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    protected void onEquip() {
        super.onEquip();
        if (this.canUseSkill) {
            this.getPlayer().setAllowFlight(true);
        }
    }

    @EventHandler
    public void onPlayerToggleFlight(PlayerToggleFlightEvent event) {
        Player player = event.getPlayer();
        if (!this.canUseSkill || player != this.getPlayer() || player.getGameMode() == GameMode.CREATIVE || event.getPlayer().isFlying()) {
            return;
        }
        player.setFlying(false);
        event.setCancelled(true);
        if (!this.getOwner().getAndSetCooldown(this.cosmeticType, 3.5, 0.0)) {
            return;
        }
        if (this.mode.equalsIgnoreCase("Fast")) {
            if (!this.fast(player)) {
                return;
            }
        } else if (this.mode.equalsIgnoreCase("Enderpearl")) {
            player.launchProjectile(EnderPearl.class, player.getLocation().getDirection());
        } else {
            this.rayTrace(player);
        }
    }

    private void rayTrace(Player player) {
        Block b = player.getTargetBlock(null, 17);
        Location loc = b.getLocation();
        loc.setPitch(player.getLocation().getPitch());
        loc.setYaw(player.getLocation().getYaw());
        this.getUltraCosmetics().getScheduler().teleportAsync((Entity)player, loc);
        this.spawnFireworks(loc);
    }

    private void spawnFireworks(Location loc) {
        EntitySpawner.spawnFireworks(loc.add(0.5, 0.0, 0.5), Color.BLACK, Color.BLACK);
    }

    private boolean fast(Player player) {
        Vector v = player.getLocation().getDirection();
        v.setY(0);
        v.normalize().multiply(16);
        Location loc = player.getLocation().add(v);
        if (!BlockUtils.isAir(loc.getBlock().getType())) {
            this.getUltraCosmetics().getScheduler().teleportAsync((Entity)player, loc);
            this.spawnFireworks(loc.add(0.5, 0.0, 0.5));
            return true;
        }
        return false;
    }

    @Override
    public void onClear() {
        if (this.canUseSkill && this.getPlayer().getGameMode() != GameMode.CREATIVE) {
            this.getPlayer().setAllowFlight(false);
        }
    }
}

