/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.morphs;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.morphs.Morph;
import be.isach.ultracosmetics.cosmetics.type.CosmeticType;
import be.isach.ultracosmetics.cosmetics.type.MorphType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.util.MathUtils;
import com.cryptomorin.xseries.XSound;
import org.bukkit.GameMode;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.util.Vector;

public abstract class MorphFlightAbility
extends Morph
implements Updatable {
    private static final double COOLDOWN = 2.0;
    private final XSound.SoundPlayer sound;

    public MorphFlightAbility(UltraPlayer owner, MorphType type, UltraCosmetics ultraCosmetics, XSound sound) {
        super(owner, type, ultraCosmetics);
        this.sound = sound.record().withVolume(0.4f).soundPlayer().forPlayers(new Player[]{this.getPlayer()});
    }

    @Override
    protected void onEquip() {
        super.onEquip();
        if (this.canUseSkill) {
            this.getPlayer().setAllowFlight(true);
        }
    }

    @EventHandler
    public void onPlayerToggleFlight(PlayerToggleFlightEvent event) {
        if (this.canUseSkill && event.getPlayer() == this.getPlayer() && event.getPlayer().getGameMode() != GameMode.CREATIVE && !event.getPlayer().isFlying()) {
            event.getPlayer().setFlying(false);
            event.setCancelled(true);
            if (!this.getOwner().canUse((CosmeticType<?>)this.getType())) {
                return;
            }
            Vector v = event.getPlayer().getLocation().getDirection();
            v.setY(0.75);
            MathUtils.applyVelocity((Entity)this.getPlayer(), v);
            this.sound.play();
            this.getOwner().setCooldown((CosmeticType<?>)this.getType(), 2.0, 0.0);
        }
    }

    @Override
    public void onUpdate() {
        if (this.canUseSkill && UltraCosmeticsData.get().displaysCooldownInBar() && !this.getOwner().canUse((CosmeticType<?>)this.getType())) {
            this.getOwner().sendCooldownBar((CosmeticType<?>)this.getType(), 2.0, 0.0);
        }
    }

    @Override
    public void onClear() {
        if (this.canUseSkill && this.getPlayer().getGameMode() != GameMode.CREATIVE) {
            this.getPlayer().setAllowFlight(false);
        }
    }
}

