/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.mounts;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.cosmetics.mounts.MountAbstractHorse;
import be.isach.ultracosmetics.cosmetics.type.MountType;
import be.isach.ultracosmetics.player.UltraPlayer;
import com.cryptomorin.xseries.XPotion;
import com.cryptomorin.xseries.particles.ParticleDisplay;
import com.cryptomorin.xseries.particles.XParticle;
import java.awt.Color;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Horse;
import org.bukkit.potion.PotionEffect;

public class MountDruggedHorse
extends MountAbstractHorse {
    private static final int AMBIENT_ALPHA = 38;
    private final ParticleDisplay fireworkDisplay = ParticleDisplay.of((XParticle)XParticle.FIREWORK).offset(0.4, 0.2, 0.4).withCount(5);
    private final ParticleDisplay effectDisplay = this.fireworkDisplay.copy().withParticle(XParticle.EFFECT);
    private final ParticleDisplay ambientEffectDisplay = this.effectDisplay.copy().withCount(1);
    private final ParticleDisplay coloredEffectDisplay = this.effectDisplay.copy().withColor(new Color(5, 255, 0));

    public MountDruggedHorse(UltraPlayer owner, MountType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    public void setupEntity() {
        super.setupEntity();
        Horse horse = (Horse)this.getEntity();
        horse.setColor(Horse.Color.CHESTNUT);
        horse.setJumpStrength(1.3);
        this.getUltraCosmetics().getScheduler().runAtEntity((Entity)this.getPlayer(), task -> this.getPlayer().addPotionEffect(new PotionEffect(XPotion.NAUSEA.getPotionEffectType(), 10000000, 1)));
    }

    @Override
    public void onUpdate() {
        Location loc = this.entity.getLocation().add(0.0, 1.0, 0.0);
        this.fireworkDisplay.spawn(loc);
        this.effectDisplay.spawn(loc);
        this.coloredEffectDisplay.spawn(loc);
        ThreadLocalRandom r = ThreadLocalRandom.current();
        for (int i = 0; i < 5; ++i) {
            this.ambientEffectDisplay.withColor(new Color(r.nextInt(256), r.nextInt(256), r.nextInt(256), 38)).spawn(loc);
        }
    }

    @Override
    protected void onClear() {
        this.getPlayer().removePotionEffect(XPotion.NAUSEA.getPotionEffectType());
        super.onClear();
    }
}

