/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.mounts;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.cosmetics.mounts.Mount;
import be.isach.ultracosmetics.cosmetics.type.MountType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.mobchip.EntityBrain;
import be.isach.ultracosmetics.shaded.mobchip.bukkit.BukkitBrain;
import com.cryptomorin.xseries.particles.ParticleDisplay;
import com.cryptomorin.xseries.particles.XParticle;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Sheep;
import org.bukkit.util.Vector;

public class MountNyanSheep
extends Mount {
    private static final List<Color> COLORS = new ArrayList<Color>();
    private EntityBrain brain;
    private final ParticleDisplay display = ParticleDisplay.of((XParticle)XParticle.DUST).withCount(10);

    public MountNyanSheep(UltraPlayer owner, MountType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    public void setupEntity() {
        Sheep sheep = (Sheep)this.entity;
        sheep.setNoDamageTicks(Integer.MAX_VALUE);
        this.brain = BukkitBrain.getBrain((Mob)sheep);
        this.brain.getGoalAI().clear();
        this.brain.getTargetAI().clear();
    }

    @Override
    public void onUpdate() {
        this.move();
        ((Sheep)this.entity).setColor(DyeColor.values()[RANDOM.nextInt(16)]);
        Location particleLoc = this.entity.getLocation().add(this.entity.getLocation().getDirection().normalize().multiply(-2)).add(0.0, 1.2, 0.0);
        for (Color rgbColor : COLORS) {
            this.display.withColor(rgbColor).spawn(particleLoc);
            particleLoc.subtract(0.0, 0.2, 0.0);
        }
    }

    private void move() {
        Location target = this.getPlayer().getLocation();
        Vector vel = target.getDirection().setY(0).normalize().multiply(4);
        target.add(vel);
        this.brain.getController().moveTo(target, 2.0);
    }

    static {
        COLORS.add(new Color(255, 0, 0));
        COLORS.add(new Color(255, 165, 0));
        COLORS.add(new Color(255, 255, 0));
        COLORS.add(new Color(154, 205, 50));
        COLORS.add(new Color(30, 144, 255));
        COLORS.add(new Color(148, 0, 211));
    }
}

